<?php

namespace App\sys\Repository\Roles_Groups;

use App\Models\Role;
use Illuminate\Support\Facades\DB;

class RoleRepository
{
    private $role;

    public function __construct()
    {
        $this->role = new Role;
    }

    protected $columns = [
        'id' => 'id',
        'name' => 'name',
        'created_at' => 'created_at',
    ];

    public function getPaginated()
    {
        // 1. جلب متغيرات الطلب
        $column = request('sort_by', null);
        $order = request('sort_order', 'desc'); // 'desc' كقيمة افتراضية
        $name = request('name', null);
        $limit = request('limit', 15);

        // 2. بناء الاستعلام
        $query = Role::query()->with('permissions')
            ->when($name, function ($q, $name) {
                // البحث بالاسم
                $q->where('name', 'LIKE', "%$name%");
            });

        // 3. إضافة الترتيب (Sorting)
        // نتأكد أن العمود المطلوب موجود في قائمة الأعمدة المسموحة
        if ($column && array_key_exists($column, $this->columns)) {
            $query->orderBy($this->columns[$column], $order);
        } else {
            // ترتيب افتراضي إذا لم يتم تحديد عمود صالح
            $query->orderBy('created_at', $order);
        }

        // 4. إرجاع النتيجة مع التقسيم
        return $query->paginate($limit);
    }

    public function add($data)
    {

        $role = Role::create([
            'name' => $data['name'],
            'description' => $data['description'] ?? null,
        ]);

        if (isset($data['permissions']) && ! empty($data['permissions'])) {
            $permissionsDetails = DB::table('permissions')
                ->whereIn('id', $data['permissions'])
                ->select('id', 'Controller_name', 'collection_name')
                ->get();

            $syncData = [];
            foreach ($permissionsDetails as $permission) {
                // تأكد إن Controller_name مش null
                $functionName = $permission->Controller_name ?? 'Unknown';
                $collectionName = $permission->collection_name ?? null;

                $syncData[$permission->id] = [
                    'function_name' => $functionName,
                    'collection_name' => $collectionName,
                ];
            }

            $role->permissions()->sync($syncData);
        }

        return $role;
    }

    public function updated($id, $data)
    {
        $role = Role::find($id);

        if (! $role) {
            return false;
        }

        if (array_key_exists('name', $data)) {
            $role->name = $data['name'];
        }

        if (array_key_exists('description', $data)) {
            $role->description = $data['description'];
        }
        $role->save();

        if (isset($data['permissions'])) {
            $permissionsDetails = DB::table('permissions')
                ->whereIn('id', $data['permissions'])
                ->select('id', 'Controller_name', 'collection_name')
                ->get();

            $syncData = [];
            foreach ($permissionsDetails as $permission) {
                $functionName = $permission->Controller_name ?? 'Unknown';
                $collectionName = $permission->collection_name ?? null;
                $syncData[$permission->id] = [
                    'function_name' => $functionName,
                    'collection_name' => $collectionName,
                ];
            }

            $role->permissions()->sync($syncData);
        }

        return $role;
    }

    public function deletee($id)
    {
        return Role::destroy($id);
    }

    public function syncPermissions(int $id, array $permissionIds)
    {

        $role = Role::find($id);
        if (! $role) {
            return false;
        }
        $permissions = DB::table('permissions')
            ->whereIn('id', $permissionIds)
            ->select('id', 'Controller_name', 'collection_name')
            ->get();

        $syncData = [];
        foreach ($permissions as $permission) {
            $syncData[$permission->id] = [
                'function_name' => $permission->Controller_name,
                'collection_name' => $permission->collection_name];
        }

        $role->permissions()->sync($syncData);

        return true;

    }

    public function find($id)
    {
        return Role::find($id);
    }

    public function show($id)
    {
        // بنجيب الداتا كـ Object الأول
        $role = Role::with('permissions')->find($id);

        if (! $role) {
            return null;
        }

        // بنعمل تنسيق للصلاحيات
        $formattedPermissions = $role->permissions
            ->groupBy('Controller_name')
            ->values()
            ->map(function ($permissions, $index) {
                // لاحظ هنا بنستخدم -> لأن permissions لسه Collection of Objects
                $controllerName = $permissions->first()->Controller_name;

                return [
                    'id' => $index + 1,
                    'name' => $controllerName,
                    'key' => strtoupper(str_replace(' ', '_', $controllerName)),
                    'permissions' => $permissions->map(function ($permission) {
                        return [
                            'id' => $permission->id, // -> سليمة هنا
                            'permission_name' => $permission->permission_name,
                            'controller_name' => $permission->Controller_name,
                            'collection_name' => $permission->collection_name, // Added collection_name// 'pivot'           => $permission->pivot
                        ];
                    }),
                ];
            });

        // في آخر خطوة بنحول الرول لمصفوفة عشان ندمج الشكل الجديد
        $roleData = $role->toArray();
        $roleData['permissions'] = $formattedPermissions;

        return $roleData; // بترجع Array
    }
}
