<?php

namespace App\sys\Services\General;

use App\sys\Repository\General\TransportationModesTranslationRepository;
use App\sys\Services;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;

class TransportationModesTranslationService extends Services
{
    private $repo;

    private $repoTranslation;

    public function __construct()
    {
        $this->repo = new TransportationModesTranslationRepository;

    }

    public function saveTranslation(array $data, $transportation_id)
    {
        $rules = ['tranortation_id' => 'required|integer|exists:ge_transportation_modes,id'];
        $combinations = [];
        $customErrors = [];

        foreach ($data as $index => $row) {
            $rowId = $row['id'] ?? null;
            $langId = $row['lang_id'] ?? null;
            $rules["$index.id"] = 'sometimes|nullable|exists:ge_transportation_modes_translation,id';
            $rules["$index.language_id"] = [
                Rule::requiredIf(empty($rowId)),
                'exists:languages,id',
                Rule::unique('ge_transportation_modes_translation', 'lang_id')
                    ->where(fn ($query) => $query->where('tranortation_id', $transportation_id))
                    ->ignore($rowId),
            ];
            $rules["$index.name"] = 'nullable|string|max:300';

            if ($langId) {
                $key = $transportation_id.'-'.$langId;
                if (in_array($key, $combinations)) {
                    $customErrors["$index.language_id"] = 'Same language duplicated for the same Transportation Mode.';
                } else {
                    $combinations[] = $key;
                }
            }
        }

        $validator = Validator::make(array_merge($data, ['tranortation_id' => $transportation_id]), $rules);
        $validator->after(function ($validator) use ($customErrors) {
            foreach ($customErrors as $field => $message) {
                $validator->errors()->add($field, $message);
            }
        });
        if ($validator->fails()) {
            $this->setError($validator->errors());

            return false;
        }

        return $this->repo->save($data, $transportation_id);
    }

    public function getTranslation($transportation_id)
    {
        return $this->repo->get($transportation_id);
    }

    public function delLang($id)
    {
        $rules = [
            'id' => 'required|integer|exists:ge_transportation_modes_translation,id',
        ];
        $validator = Validator::make(['id' => $id], $rules);
        if ($validator->fails()) {
            $this->setError($validator->errors());

            return false;
        }

        return $this->repo->del($id);
    }
}
