<?php

namespace App\Http\Controllers\General;

use App\Http\Controllers\Controller;
use App\Http\Resources\General\TransportationReason\TransportationReasonLangResource;
use App\Http\Resources\General\TransportationReasonHistoryResource;
use App\Http\Resources\TransportationReasonCollection;
use App\Http\Resources\TransportationReasonResource;
use App\sys\ApiResponse;
use App\sys\Services\General\TransportationReasonService;
use App\sys\Services\General\TransportationReasonTranslationService;
use Illuminate\Http\Request;

class TransportationReasonController extends Controller
{
    use ApiResponse;

    private $service;

    private $translationService;

    public function __construct()
    {
        $this->service = new TransportationReasonService;
        $this->translationService = new TransportationReasonTranslationService;
    }

    public function create(Request $request)
    {
        if ($item = $this->service->create($request->all())) {
            $collect = new TransportationReasonResource($item);

            return $this->apiResponse(200, 'Transportation Reason created successfully', null, $collect);
        }
        $errors = $this->service->errors();

        return $this->apiResponse(400, 'Error creating Transportation Reason', $errors, null);
    }

    public function update(Request $request)
    {
        if ($item = $this->service->update($request->all())) {
            $collect = new TransportationReasonResource($item);

            return $this->apiResponse(200, 'Transportation Reason updated successfully', null, $collect);
        }
        $errors = $this->service->errors();

        return $this->apiResponse(400, 'Error updating Transportation Reason', $errors, null);
    }

    public function index()
    {
        $data = $this->service->index();
        $collect = new TransportationReasonCollection($data);

        return $this->apiResponse(200, 'Transportation Reasons retrieved successfully', null, $collect);
    }

    public function getById($id)
    {
        if ($data = $this->service->getById($id)) {
            $collect = new TransportationReasonResource($data);

            return $this->apiResponse(200, 'Transportation Reason retrieved successfully', null, $collect);
        }

        return $this->apiResponse(400, 'Transportation Reason not found', ['not found'], null);
    }

    public function getActive()
    {
        $data = $this->service->getActive();
        $collect = new TransportationReasonCollection($data);

        return $this->apiResponse(200, 'Active Transportation Reasons retrieved successfully', null, $collect);
    }

    public function destroy(Request $request)
    {
        $ids = $request->input('ids', []);
        if (! is_array($ids) || empty($ids)) {
            return $this->apiResponse(400, 'No IDs provided for deletion', null, null);
        }
        $result = $this->service->del($ids);
        if ($result) {
            return $this->apiResponse(200, 'Transportation Reasons deleted successfully', null, null);
        }
        $errors = $this->service->errors();

        return $this->apiResponse(400, 'fail', $errors, null);
    }

    public function saveTranslation(Request $request, $id)
    {
        if (! $this->translationService->saveTranslation($request->all(), $id)) {
            $errors = $this->translationService->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        return $this->apiResponse(200, 'success', null, null);
    }

    public function getTranslation($id)
    {
        $data = $this->service->getTrans($id);
        $collection = new TransportationReasonLangResource($data);

        return $this->apiResponse(200, 'success', null, $collection);
    }

    public function delLang($id)
    {
        if ($this->translationService->delLang($id)) {
            return $this->apiResponse(200, 'success', null, null);
        }

        $errors = $this->translationService->errors();

        return $this->apiResponse(400, 'fail', $errors, null);
    }

    public function getAllChanges($id)
    {
        $item = $this->service->getById($id);
        if (! $item) {
            $errors = $this->service->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }
        $changes = $this->service->getAllChanges($item);

        return $this->apiResponse(200, 'success', null, TransportationReasonHistoryResource::collection($changes));
    }
}
