<?php

namespace App\Http\Resources\Accommodation;

use Illuminate\Http\Resources\Json\JsonResource;

class AccommodationsLangResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'description' => $this->description,
            'type' => $this->type,
            'rating_id' => $this->rating_id,
            'country_id' => $this->country_id,
            'city_id' => $this->city_id,
            'active' => $this->is_active,
            'address' => $this->address,
            'phone' => $this->phone,
            'email' => $this->email,
            'website' => $this->website,
            'taxable' => (bool) $this->taxable,
            'is_main_provider' => (bool) $this->is_main_provider,
            'google_map_link' => $this->google_map_link,
            'created_at' => $this->created,
            'updated_at' => $this->modified,
            'translations' => ($this->translations && $this->translations->isNotEmpty())
                ? AccommodationsTranslationResource::collection($this->translations)
                : null,
        ];
    }
}
