<?php

namespace App\Http\Resources\Accounting;

use Illuminate\Http\Resources\Json\JsonResource;

class TreeAccountingSelectResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->relationLoaded('currentTranslation') && $this->currentTranslation
                ? ($this->currentTranslation->title ?? $this->title)
                : $this->title,
            'currency_id' => $this->currency_id,
            'currency' => $this->when($this->relationLoaded('currency') && $this->currency, function () {
                return [
                    'id' => $this->currency->id,
                    'name' => $this->currency->relationLoaded('currentTranslation') && $this->currency->currentTranslation
                        ? ($this->currency->currentTranslation->name ?? $this->currency->name)
                        : $this->currency->name,
                    'symbol' => $this->currency->symbol,
                    'is_default' => $this->currency->status ?? false,
                    'exchange_rate' => $this->currency->exchange_rate,
                    'code' => $this->currency->code,
                ];
            }),
        ];
    }
}
