<?php

namespace App\Http\Resources\General\City;

use Illuminate\Http\Resources\Json\JsonResource;

class CityTranslationResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'lang_id' => $this->lang_id,
            'lang_name' => $this->getLang->name ?? null,
            'lang_code' => $this->getLang->code ?? null,
            'city_id' => $this->city_id,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
