<?php

namespace App\Http\Resources\General\Domain;

use Illuminate\Http\Resources\Json\JsonResource;

class DomainResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->relationLoaded('currentTranslation')
                ? ($this->currentTranslation->title ?? $this->title)
                : $this->title,
            'tax_rate_id' => $this->tax_rate_id,
            'tax_rate' => $this->taxRate ?? null,
            'type' => $this->type,
            'active' => $this->enabled_disable,
            'created_at' => $this->created,
            'updated_at' => $this->modified,
            'translations' => ($this->translations && $this->translations->isNotEmpty())
                ? DomainTranslationResource::collection($this->translations)
                : null,
        ];
    }
}
