<?php

namespace App\Models\Accounting;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CostCenter extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'name',
        'cost_center_id',
        'number',
        'full_number',
    ];

    public function getAllChildren()
    {
        return $this->hasMany(self::class, 'cost_center_id')->with('getAllChildren');
    }

    public function parent()
    {
        return $this->belongsTo(self::class, 'cost_center_id');
    }

    public function transfers()
    {
        return $this->hasMany(Transfer::class, 'cost_center_id');
    }
}
