<?php

namespace App\Models\Accounting;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use OwenIt\Auditing\Auditable as AuditableTrait;
use OwenIt\Auditing\Contracts\Auditable;

class Paytype extends Model implements Auditable
{
    use AuditableTrait, HasFactory, SoftDeletes;

    protected $table = 'pay_type';

    protected $fillable = [
        'title',
        'type',
        'is_protected',
    ];

    protected $dates = ['deleted_at'];

    protected $casts = [
        'is_protected' => 'boolean',
    ];

    /**
     * Attributes to audit
     */
    protected $auditInclude = [
        'title',
        'type',
    ];

    /**
     * Attributes to exclude from audit
     */
    protected $auditExclude = [
        'created',
        'modified',
    ];

    /**
     * Audit events to record
     */
    protected $auditEvents = [
        'updated',
    ];

    public function accounting()
    {
        return $this->hasMany(PaytypeAccounting::class, 'pay_type_id')->with('currency', 'treeAccountingTransfer', 'treeAccountCommission');
    }

    public function translations()
    {
        return $this->hasMany(PaytypeTranslation::class, 'pay_type_id');
    }

    public function currentTranslation()
    {
        return $this->hasOne(PaytypeTranslation::class, 'pay_type_id')
            ->where('lang_id', app('lang_id'));
    }
}
