<?php

namespace App\sys\Repository\Auth;

use App\Models\User;
use Illuminate\Support\Facades\Hash;

class AuthRepository
{
    protected $userModel;

    public function __construct(User $userModel)
    {
        $this->userModel = $userModel;
    }

    public function attemptLogin(array $credentials)
    {
        // 1. البحث عن المستخدم عن طريق الإيميل
        $user = User::where('email', $credentials['email'])->first();

        if (! $user) {
            return false; // المستخدم غير موجود
        }

        if (! Hash::check($credentials['password'], $user->password)) {
            return false;

        }
        if (! $user->is_active) {
            return 'inactive';
        }

        return $user;
    }

    public function ChangePassword($user, $data)
    {

        if (! Hash::check($data['old_password'], $user->password)) {
            return false;
        }

        $user->password = Hash::make($data['new_password']);
        $user->save();

        return true;

    }
}
