<?php

namespace App\sys\Services\General;

use App\sys\Repository\General\WorkPeriodRepository;
use App\sys\Services;
use Illuminate\Support\Facades\Validator;

class WorkPeriodService extends Services
{
    protected WorkPeriodRepository $workPeriodRepository;

    public function __construct(WorkPeriodRepository $workPeriodRepository)
    {
        $this->workPeriodRepository = $workPeriodRepository;
    }

    public function getPaginatedWorkPeriod()
    {
        return $this->workPeriodRepository->getPaginated();
    }

    public function getWorkPeriodById(int $id)
    {
        $rules = [
            'id' => ['required', 'integer', 'exists:ge_work_period,id'],
        ];
        $validator = Validator::make(['id' => $id], $rules);
        if ($validator->fails()) {
            $this->setError($validator->errors());

            return false;
        }

        return $this->workPeriodRepository->findByIdOrFail($id);
    }

    public function createWorkPeriod($request)
    {
        $rules = [
            'name' => ['required', 'string', 'max:255'],
            'active' => ['required', 'in:0,1'],
        ];
        $validator = Validator::make($request, $rules);
        if ($validator->fails()) {
            $this->setError($validator->errors());

            return false;
        }
        $workPeriod = $this->workPeriodRepository->create($request);
        $this->syncTranslations($workPeriod);

        return $workPeriod;
    }

    public function updateWorkPeriod($request)
    {
        $rules = [
            'id' => ['required', 'integer', 'exists:ge_work_period,id'],
            'name' => ['sometimes', 'string', 'max:255'],
            'active' => ['sometimes', 'in:0,1'],
        ];
        $validator = Validator::make($request, $rules);
        if ($validator->fails()) {
            $this->setError($validator->errors());

            return false;
        }
        $item = $this->workPeriodRepository->findByIdOrFail($request['id']);

        return $this->workPeriodRepository->update($item, $request);
    }

    public function deleteWorkPeriod(int $id)
    {
        $rules = [
            'id' => ['required', 'integer', 'exists:ge_work_period,id'],
        ];
        $validator = Validator::make(['id' => $id], $rules);
        if ($validator->fails()) {
            $this->setError($validator->errors());

            return false;
        }
        $item = $this->workPeriodRepository->findByIdOrFail($id);

        return $this->workPeriodRepository->delete($item);
    }

    public function del(array $ids)
    {
        return $this->workPeriodRepository->del($ids);
    }

    public function getActive()
    {
        return $this->workPeriodRepository->getActive();
    }

    public function getByIdWithTranslation($id)
    {
        $rules = [
            'id' => ['required', 'integer', 'exists:ge_work_period,id'],
        ];
        $validator = Validator::make(['id' => $id], $rules);
        if ($validator->fails()) {
            $this->setError($validator->errors());

            return false;
        }
        $workPeriod = $this->workPeriodRepository->getByIdWithTranslation($id);

        return $this->syncTranslations($workPeriod, true);
    }

    public function getAllChanges($workPeriod)
    {
        return $this->workPeriodRepository->getAllChanges($workPeriod);
    }
}
