<?php

use App\Http\Controllers\Accommodation\AccommodationsController;
use App\Http\Controllers\Accommodation\ExtraController;
use App\Http\Controllers\Accommodation\MealPlanesController;
use App\Http\Controllers\Accommodation\RatingContoller;
use App\Http\Controllers\Accommodation\RoomTypesController;
use App\Http\Controllers\Accommodation\RoomViewController;
use App\Http\Controllers\Accounting\ConstraintController;
use App\Http\Controllers\Accounting\CostCenterController;
use App\Http\Controllers\Accounting\Reports\ReportController;
use App\Http\Controllers\Accounting\TreeAccountingController;
use App\Http\Controllers\Accounting\TreeAccountSettingController;
use App\Http\Controllers\Auth\AuthController;
use App\Http\Controllers\General\CityController;
use App\Http\Controllers\General\CountryController;
use App\Http\Controllers\General\CurrencyController;
use App\Http\Controllers\General\DomainController;
use App\Http\Controllers\General\NationalityController;
use App\Http\Controllers\General\OperationDataController;
use App\Http\Controllers\General\ServiceController;
use App\Http\Controllers\General\TaxRateController;
use App\Http\Controllers\General\Translation\TranslationController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\Invoice\InvoiceServicesController;
use App\Http\Controllers\Lagnuages\LagnuagesControllers;
use App\Http\Controllers\Profile\CustomerController;
use App\Http\Controllers\Profile\ProfileController;
use App\Http\Controllers\Profile\TravelerController;
use App\Http\Controllers\Roles_Groups\GroupController;
use App\Http\Controllers\Roles_Groups\PermissionController;
use App\Http\Controllers\Roles_Groups\RoleController;
use App\Http\Controllers\Suppliers\SuppliersControllers;
use App\Http\Controllers\User\UserController;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Route;

Route::get('test', function () {
    return \App\Models\Accounting\TreeAccounting::with('getAllChildren')->find(1);
});

Route::get('/import-translations', function () {
    $jsonPath = public_path('data.json');

    if (! File::exists($jsonPath)) {
        return 'File not found at: '.$jsonPath;
    }

    $jsonContent = File::get($jsonPath);
    $data = json_decode($jsonContent, true);

    if (! $data) {
        return 'Error decoding JSON file.';
    }
    $language_id = 3;
    $user_id = 1;
    $counter = 0;
    foreach ($data as $controllerName => $translations) {

        foreach ($translations as $key => $value) {
            DB::table('language_translations')->updateOrInsert(
                [
                    'language_id' => $language_id,
                    'key' => $key,
                    'controller_name' => $controllerName,
                ],
                [
                    'value' => $value,
                    'is_translated' => 0,
                    'created_at' => now(),
                    'updated_at' => now(),
                ]
            );
            $counter++;
        }
    }

    return "Done! Processed {$counter} records successfully.";
});
Route::middleware('ensure.auth')->group(function () {
    Route::prefix('dashboard')->group(function () {
        Route::get('/', [HomeController::class, 'dashboard']);
        Route::get('profiles-chart/{period?}', [HomeController::class, 'profilesChartDashboard']);
        Route::get('daily-checks', [HomeController::class, 'dailyCheckInAndOutChartDashboard']);
        Route::get('invoices-payments', [HomeController::class, 'invoicesAndPaymentsChartDashboard']);
        Route::get('sales-performance', [HomeController::class, 'salesPerformanceChartDashboard']);
        Route::get('monthly-invoices', [HomeController::class, 'monthlyInMonthlyInvoiceChartDashboard']);
        Route::get('invoice-services', [HomeController::class, 'invoiceServices']);
    });
    Route::prefix('general')->group(function () {
        Route::get('airline/{code?}', '\App\Http\Controllers\AirLinesControlers@search');
        Route::get('airport/{code?}', '\App\Http\Controllers\AirportsController@search');
        Route::pattern('limit', '[0-9]+');
        Route::pattern('id', '[0-9]+');
        Route::prefix('category')->controller(\App\Http\Controllers\General\CategoryController::class)->group(function () {
            Route::get('/', 'index')->name('general.categories');
            Route::get('/show/{id}', 'show')->name('general.categories.show')->middleware('can:VIEW_CATEGORIES');
            Route::post('/create', 'create')->name('general.categories.create')->middleware('can:ADD_CATEGORY');
            Route::post('/update', 'update')->name('general.categories.update')->middleware('can:EDIT_CATEGORY');
            Route::post('/delete', 'destroy')->name('general.categories.delete')->middleware('can:DELETE_CATEGORY');
            Route::get('/active', 'getActive')->name('general.categories.getActive');
            Route::post('/translation/{id}', 'saveTranslation')->name('general.categories.saveTranslation')->middleware('can:TRANSLATE_CATEGORY');
            Route::get('/translation/{id}', 'getTranslation')->name('general.categories.getTranslation')->middleware('can:TRANSLATE_CATEGORY');
            Route::get('/translation/del/{id}', 'delLang')->name('general.categories.delTranslation')->middleware('can:TRANSLATE_CATEGORY');
            Route::get('/changes/{id}', 'getAllChanges')->name('general.categories.changes')->middleware('can:VIEW_CATEGORIES');
        });
        // Countries & Cities
        Route::prefix('countries')->controller(CountryController::class)->group(function () {
            Route::get('/', 'index')->name('general.countries')->middleware('can:VIEW_COUNTRIES');
            Route::get('/active', 'getActive')->name('general.countries.getActive');
            Route::get('/show/{id}', 'show')->name('general.countries.show')->middleware('can:VIEW_COUNTRIES');
            Route::get('/{id}/cities', 'getCities')->name('general.countries.cities');
            Route::post('/create', 'store')->name('general.countries.create')->middleware('can:ADD_COUNTRY');
            Route::post('/update', 'update')->name('general.countries.update')->middleware('can:EDIT_COUNTRY');
            Route::post('/delete', 'destroy')->name('general.countries.delete')->middleware('can:DELETE_COUNTRY');
            Route::post('/translation/{id}', 'saveTranslation')->name('general.countries.saveTranslation')->middleware('can:TRANSLATE_COUNTRY');
            Route::get('/translation/{id}', 'getTranslation')->name('general.countries.getTranslation')->middleware('can:TRANSLATE_COUNTRY');
            Route::get('/translation/del/{id}', 'delLang')->name('general.countries.delTranslation')->middleware('can:TRANSLATE_COUNTRY');
            Route::get('/changes/{id}', 'getAllChanges')->name('general.countries.changes')->middleware('can:VIEW_COUNTRIES');
        });

        Route::prefix('guide-languages')->controller(\App\Http\Controllers\General\GuideLanguageController::class)->group(function () {
            Route::get('/', 'index')->name('general.guide_languages')->middleware('can:VIEW_TOUR_GUIDE_LANGUAGES');
            Route::get('/active', 'getActive')->name('general.guide_languages.getActive');
            Route::get('/show/{id}', 'show')->name('general.guide_languages.show')->middleware('can:VIEW_TOUR_GUIDE_LANGUAGES');
            Route::post('/create', 'store')->name('general.guide_languages.create')->middleware('can:ADD_TOUR_GUIDE_LANGUAGE');
            Route::post('/update', 'update')->name('general.guide_languages.update')->middleware('can:EDIT_TOUR_GUIDE_LANGUAGE');
            Route::post('/delete', 'destroy')->name('general.guide_languages.delete')->middleware('can:DELETE_TOUR_GUIDE_LANGUAGE');
            Route::post('/translation/{id}', 'saveTranslation')->name('general.guide_languages.saveTranslation')->middleware('can:TRANSLATE_TOUR_GUIDE_LANGUAGE');
            Route::get('/translation/{id}', 'getTranslation')->name('general.guide_languages.getTranslation')->middleware('can:TRANSLATE_TOUR_GUIDE_LANGUAGE');
            Route::get('/translation/del/{id}', 'delLang')->name('general.guide_languages.delTranslation')->middleware('can:TRANSLATE_TOUR_GUIDE_LANGUAGE');
        });

        Route::prefix('cities')->controller(CityController::class)->group(function () {
            Route::get('/', 'index')->name('general.cities')->middleware('can:VIEW_CITIES');
            Route::get('/show/{id}', 'show')->name('general.cities.show')->middleware('can:VIEW_CITIES');
            Route::post('/create', 'store')->name('general.cities.create')->middleware('can:ADD_CITY');
            Route::post('/update', 'update')->name('general.cities.update')->middleware('can:EDIT_CITY');
            Route::post('/delete', 'destroy')->name('general.cities.delete')->middleware('can:DELETE_CITY');
            Route::get('/active', 'getActive')->name('general.cities.getActive');
            Route::post('/translation/{id}', 'saveTranslation')->name('general.cities.saveTranslation')->middleware('can:TRANSLATE_CITY');
            Route::get('/translation/{id}', 'getTranslation')->name('general.cities.getTranslation')->middleware('can:TRANSLATE_CITY');
            Route::get('/translation/del/{id}', 'delLang')->name('general.cities.delTranslation')->middleware('can:TRANSLATE_CITY');
            Route::get('/changes/{id}', 'getAllChanges')->name('general.cities.changes')->middleware('can:VIEW_CITIES');
        });

        Route::prefix('services')->controller(ServiceController::class)->group(function () {
            Route::get('/', 'index')
                ->name('general.services');
            Route::get('/show/{id}', 'show')
                ->name('general.services.show')
                ->middleware('canAny:VIEW_ADDITIONAL_SERVICES,VIEW_TOUR_GUIDES,VIEW_DAILY_TRANSPORTATION,VIEW_SINGLE_TRANSPORTATION,VIEW_TOUR_REPS,VIEW_DINING_ENTERTAINMENTS,VIEW_ATTRACTIONS_AND_TEMPLES,VIEW_ADDITIONAL_SERVICE_HISTORY_LOG,VIEW_TOUR_GUIDE_HISTORY_LOG,VIEW_DAILY_TRANSPORTATION_HISTORY_LOG,VIEW_SINGLE_TRANSPORTATION_HISTORY_LOG,VIEW_TOUR_REP_HISTORY_LOG,VIEW_DINING_ENTERTAINMENT_HISTORY_LOG');
            Route::post('/create', 'store')
                ->name('general.services.create')
                ->middleware('canAny:ADD_ADDITIONAL_SERVICE,ADD_TOUR_GUIDE,ADD_DAILY_TRANSPORTATION,ADD_SINGLE_TRANSPORTATION,ADD_TOUR_REP,ADD_DINING_ENTERTAINMENT,ADD_ATTRACTIONS_AND_TEMPLE');
            Route::post('/update', 'update')
                ->name('general.services.update')
                ->middleware('canAny:EDIT_ADDITIONAL_SERVICE,EDIT_TOUR_GUIDE,EDIT_DAILY_TRANSPORTATION,EDIT_SINGLE_TRANSPORTATION,EDIT_TOUR_REP,EDIT_DINING_ENTERTAINMENT,EDIT_ATTRACTIONS_AND_TEMPLE');
            Route::post('/delete', 'destroy')
                ->name('general.services.delete')
                ->middleware('canAny:DELETE_ADDITIONAL_SERVICE,DELETE_TOUR_GUIDE,DELETE_DAILY_TRANSPORTATION,DELETE_SINGLE_TRANSPORTATION,DELETE_TOUR_REP,DELETE_DINING_ENTERTAINMENT,DELETE_ATTRACTIONS_AND_TEMPLE');
            Route::get('/active', 'getActive')
                ->name('general.services.getActive');
            Route::get('/type/{type}', 'getByType')
                ->name('general.services.getByType');
            Route::get('/service/{service}/currency/{currency}', 'getPricesByServiceAndCurrency')
                ->name('general.services.getPricesByServiceAndCurrency');
            Route::get('/get/currency-with-tree', 'getByType')
                ->name('general.services.getByType');
            Route::get('/currency-tree', 'getCurrencyWithTree')
                ->name('general.services.currency-tree');
            Route::post('/translation/{id}', 'saveTranslation')
                ->name('general.services.saveTranslation')
                ->middleware('canAny:TRANSLATE_ADDITIONAL_SERVICE,TRANSLATE_TOUR_GUIDE,TRANSLATE_DAILY_TRANSPORTATION,TRANSLATE_SINGLE_TRANSPORTATION,TRANSLATE_TOUR_REP,TRANSLATE_DINING_ENTERTAINMENT,TRANSLATE_ATTRACTIONS_AND_TEMPLE');
            Route::get('/translation/{id}', 'getTranslation')
                ->name('general.services.getTranslation')
                ->middleware('canAny:TRANSLATE_ADDITIONAL_SERVICE,TRANSLATE_TOUR_GUIDE,TRANSLATE_DAILY_TRANSPORTATION,TRANSLATE_SINGLE_TRANSPORTATION,TRANSLATE_TOUR_REP,TRANSLATE_DINING_ENTERTAINMENT,TRANSLATE_ATTRACTIONS_AND_TEMPLE');
            Route::get('/translation/del/{id}', 'delLang')
                ->name('general.services.delTranslation')
                ->middleware('canAny:TRANSLATE_ADDITIONAL_SERVICE,TRANSLATE_TOUR_GUIDE,TRANSLATE_DAILY_TRANSPORTATION,TRANSLATE_SINGLE_TRANSPORTATION,TRANSLATE_TOUR_REP,TRANSLATE_DINING_ENTERTAINMENT,TRANSLATE_ATTRACTIONS_AND_TEMPLE');
        });

        Route::prefix('currencies')->controller(CurrencyController::class)->group(function () {
            Route::get('/', 'index')->name('general.currencies')->middleware('can:VIEW_CURRENCIES');
            Route::get('/show/{id}', 'show')->name('general.currencies.show')->middleware('can:VIEW_CURRENCIES');
            Route::post('/create', 'store')->name('general.currencies.create')->middleware('can:ADD_CURRENCY');
            Route::post('/update', 'update')->name('general.currencies.update')->middleware('can:EDIT_CURRENCY');
            Route::get('/default', 'getDefault')->name('general.countries.getDefault');
            Route::get('/active', 'getActive')->name('general.currencies.getActive');
            Route::post('/delete', 'del')->name('general.currencies.delete')->middleware('can:DELETE_CURRENCY');
            Route::post('/translation/{id}', 'saveTranslation')->name('general.currencies.saveTranslation')->middleware('can:TRANSLATE_CURRENCY');
            Route::get('/translation/{id}', 'getTranslation')->name('general.currencies.getTranslation')->middleware('can:TRANSLATE_CURRENCY');
            Route::get('/translation/del/{id}', 'delLang')->name('general.currencies.delTranslation')->middleware('can:TRANSLATE_CURRENCY');
            Route::get('/changes/{id}', 'getAllChanges')->name('general.currencies.changes')->middleware('can:VIEW_CURRENCIES');
        });

        Route::prefix('nationalities')->controller(NationalityController::class)->group(function () {
            Route::get('/', 'index')->name('general.nationalities')->middleware('can:VIEW_NATIONALITIES');
            Route::get('/show/{id}', 'show')->name('general.nationalities.show')->middleware('can:VIEW_NATIONALITIES');
            Route::post('/create', 'store')->name('general.nationalities.create')->middleware('can:ADD_NATIONALITY');
            Route::post('/update', 'update')->name('general.nationalities.update')->middleware('can:EDIT_NATIONALITY');
            Route::post('/delete', 'destroy')->name('general.nationalities.delete')->middleware('can:DELETE_NATIONALITY');
            Route::get('/active', 'getActive')->name('general.nationalities.getActive');
            Route::post('/translation/{id}', 'saveTranslation')->name('general.nationalities.saveTranslation')->middleware('can:TRANSLATE_NATIONALITY');
            Route::get('/translation/{id}', 'getTranslation')->name('general.nationalities.getTranslation')->middleware('can:TRANSLATE_NATIONALITY');
            Route::get('/translation/del/{id}', 'delLang')->name('general.nationalities.delTranslation')->middleware('can:TRANSLATE_NATIONALITY');
            Route::get('/changes/{id}', 'getAllChanges')->name('general.nationalities.changes')->middleware('can:VIEW_NATIONALITIES');
        });

        Route::prefix('companies')->controller(\App\Http\Controllers\General\CompanyController::class)->group(function () {
            Route::get('/', 'index')->name('general.companies')->middleware('can:VIEW_COMPANIES');
            Route::get('/active', 'getActive')->name('general.companies.active');
            Route::get('/currency-tree', 'getCurrencyWithTree')->name('general.currency-tree')->middleware('can:VIEW_COMPANIES');
            Route::get('/show/{id}', 'show')->name('general.companies.show')->middleware('can:VIEW_COMPANIES');
            Route::post('/create', 'store')->name('general.companies.create')->middleware('can:ADD_COMPANY');
            Route::post('/update', 'update')->name('general.companies.update')->middleware('can:EDIT_COMPANY');
            Route::post('/delete', 'destroy')->name('general.companies.delete')->middleware('can:DELETE_COMPANY');
            Route::post('/translation/{id}', 'SaveTranslation')->name('general.companies.saveTranslation')->middleware('can:TRANSLATE_COMPANY');
            Route::get('/translation/{id}', 'getTranslation')->name('general.companies.getTranslation')->middleware('can:TRANSLATE_COMPANY');
            Route::get('/translation/del/{id}', 'delLang')->name('general.companies.delTranslation')->middleware('can:TRANSLATE_COMPANY');
            Route::post('/translation/delete', 'destroy')->name('general.companies.deleteTranslation')->middleware('can:TRANSLATE_COMPANY');
            Route::get('/changes/{id}', 'getAllChanges')->name('general.companies.changes')->middleware('can:VIEW_COMPANIES');
        });

        Route::prefix('transportation-modes')->controller(\App\Http\Controllers\General\TransportationModesController::class)->group(function () {
            Route::get('/', 'index')->name('general.transportation_modes');
            Route::post('/create', 'create')->name('general.transportation_modes.create');
            Route::post('/update', 'update')->name('general.transportation_modes.update');
            Route::post('/delete', 'destroy')->name('general.transportation_modes.delete');
            Route::get('/active', 'getActive')->name('general.transportation_modes.getActive');
            Route::get('/show/{id}', 'getById')->name('general.transportation_modes.show');
            Route::post('/translation/{id}', 'saveTranslation')->name('general.transportation_modes.saveTranslation');
            Route::get('/translation/{id}', 'getTranslation')->name('general.transportation_modes.getTranslation');
            Route::get('/translation/del/{id}', 'delLang')->name('general.transportation_modes.delTranslation');
            Route::get('/changes/{id}', 'getAllChanges')->name('general.transportation_modes.changes');
        });

        Route::prefix('transportation-reasons')->controller(\App\Http\Controllers\General\TransportationReasonController::class)->group(function () {
            Route::get('/', 'index')->name('general.transportation_reasons');
            Route::post('/create', 'create')->name('general.transportation_reasons.create');
            Route::post('/update', 'update')->name('general.transportation_reasons.update');
            Route::post('/delete', 'destroy')->name('general.transportation_reasons.delete');
            Route::get('/active', 'getActive')->name('general.transportation_reasons.getActive');
            Route::get('/show/{id}', 'getById')->name('general.transportation_reasons.show');
            Route::post('/translation/{id}', 'saveTranslation')->name('general.transportation_reasons.saveTranslation');
            Route::get('/translation/{id}', 'getTranslation')->name('general.transportation_reasons.getTranslation');
            Route::get('/translation/del/{id}', 'delLang')->name('general.transportation_reasons.delTranslation');
            Route::get('/changes/{id}', 'getAllChanges')->name('general.transportation_reasons.changes');
        });

        Route::prefix('operation-data')->controller(OperationDataController::class)->group(function () {
            Route::get('/', 'index')->name('general.operationdata')->middleware('can:VIEW_OPERATION_DATA');
            Route::get('/show/{id}', 'show')->name('general.operationdata.show')->middleware('can:VIEW_OPERATION_DATA');
            Route::post('/create', 'store')->name('general.operationdata.create')->middleware('can:ADD_OPERATION_DATA');
            Route::post('/update', 'update')->name('general.operationdata.update')->middleware('can:EDIT_OPERATION_DATA');
            Route::post('/delete', 'destroy')->name('general.operationdata.delete')->middleware('can:DELETE_OPERATION_DATA');
            Route::get('/active', 'getActive')->name('general.operationdata.getActive');
            Route::post('/translation/{id}', 'saveTranslation')->name('general.operationdata.saveTranslation')->middleware('can:TRANSLATE_OPERATION_DATA');
            Route::get('/translation/{id}', 'getTranslation')->name('general.operationdata.getTranslation')->middleware('can:TRANSLATE_OPERATION_DATA');
            Route::get('/translation/del/{id}', 'delLang')->name('general.operationdata.delTranslation')->middleware('can:TRANSLATE_OPERATION_DATA');
            Route::get('/changes/{id}', 'getAllChanges')->name('general.operationdata.changes')->middleware('can:VIEW_OPERATION_DATA');
        });

        Route::prefix('restaurants')->controller(\App\Http\Controllers\General\RestaurantController::class)->group(function () {
            Route::get('/', 'index')->name('general.restaurants')->middleware('can:VIEW_RESTAURANTS');
            Route::get('/show/{id}', 'show')->name('general.restaurants.show')->middleware('can:VIEW_RESTAURANTS');
            Route::post('/create', 'store')->name('general.restaurants.create')->middleware('can:ADD_RESTAURANT');
            Route::post('/update', 'update')->name('general.restaurants.update')->middleware('canAny:EDIT_RESTAURANT,CHANGE_RESTAURANT_STATUS');
            Route::post('/delete', 'destroy')->name('general.restaurants.delete')->middleware('can:DELETE_RESTAURANT');
            Route::get('/active', 'getActive')->name('general.restaurants.getActive');
            Route::post('/translation/{id}', 'saveTranslation')->name('general.restaurants.saveTranslation')->middleware('can:TRANSLATE_RESTAURANT');
            Route::get('/translation/{id}', 'getTranslation')->name('general.restaurants.getTranslation')->middleware('can:TRANSLATE_RESTAURANT');
            Route::get('/translation/del/{id}', 'delLang')->name('general.restaurants.delTranslation')->middleware('can:TRANSLATE_RESTAURANT');
            Route::get('/changes/{id}', 'getAllChanges')->name('general.restaurants.changes')->middleware('can:VIEW_RESTAURANTS');
        });

        Route::prefix('work-periods')->controller(\App\Http\Controllers\General\WorkPeriodController::class)->group(function () {
            Route::get('/', 'index')->name('general.workperiods')->middleware('can:VIEW_WORK_PERIODS');
            Route::get('/show/{id}', 'show')->name('general.workperiods.show')->middleware('can:VIEW_WORK_PERIODS');
            Route::post('/create', 'store')->name('general.workperiods.create')->middleware('can:ADD_WORK_PERIOD');
            Route::post('/update', 'update')->name('general.workperiods.update')->middleware('can:EDIT_WORK_PERIOD');
            Route::post('/delete', 'destroy')->name('general.workperiods.delete')->middleware('can:DELETE_WORK_PERIOD');
            Route::get('/active', 'getActive')->name('general.workperiods.getActive');
            Route::post('/translation/{id}', 'saveTranslation')->name('general.workperiods.saveTranslation')->middleware('can:EDIT_WORK_PERIOD');
            Route::get('/translation/{id}', 'getTranslation')->name('general.workperiods.getTranslation')->middleware('can:VIEW_WORK_PERIODS');
            Route::get('/translation/del/{id}', 'delLang')->name('general.workperiods.delTranslation')->middleware('can:EDIT_WORK_PERIOD');
            Route::get('/changes/{id}', 'getAllChanges')->name('general.workperiods.changes')->middleware('can:VIEW_WORK_PERIODS');
        });

        Route::prefix('area')->controller(\App\Http\Controllers\General\AreaController::class)->group(function () {
            Route::get('/', 'index')->name('general.area')->middleware('can:VIEW_REGIONS');
            Route::get('/active', 'getActive')->name('general.area.getActive')->middleware('can:VIEW_REGIONS');
            Route::get('/show/{id}', 'show')->name('general.area.show')->middleware('can:VIEW_REGIONS');
            Route::post('/create', 'store')->name('general.area.create')->middleware('can:ADD_REGION');
            Route::post('/update', 'update')->name('general.area.update')->middleware('can:EDIT_REGION');
            Route::post('/delete', 'destroy')->name('general.area.delete')->middleware('can:DELETE_REGION');
            Route::post('translation/{id}', 'saveTranslation')->name('general.area.saveTranslation')->middleware('can:TRANSLATE_REGION');
            Route::get('translation/{id}', 'getTranslation')->name('general.area.getTranslation')->middleware('can:TRANSLATE_REGION');
            Route::get('/translation/del/{id}', 'delLang')->name('general.area.delTranslation')->middleware('can:TRANSLATE_REGION');
            Route::get('/by-city/{cityId}', 'getByCity')->name('general.area.byCity')->middleware('can:VIEW_REGIONS');
            Route::get('/changes/{id}', 'getAllChanges')->name('general.area.changes')->middleware('can:VIEW_REGIONS');
        });

        Route::prefix('domains')->controller(DomainController::class)->group(function () {
            Route::get('/', 'index')->name('general.domains')->middleware('can:VIEW_DOMAINS');
            Route::get('/show/{id}', 'show')->name('general.domains.show')->middleware('can:VIEW_DOMAINS');
            Route::post('/create', 'store')->name('general.domains.create')->middleware('can:ADD_DOMAIN');
            Route::post('/update', 'update')->name('general.domains.update')->middleware('can:EDIT_DOMAIN');
            Route::post('/delete', 'destroy')->name('general.domains.delete')->middleware('can:DELETE_DOMAIN');
            Route::get('/active', 'getActive')->name('general.domains.getActive');
            Route::get('/translation/{id}', 'getTranslation')->name('general.domains.getTranslation')->middleware('can:TRANSLATE_DOMAIN');
            Route::post('/translation/{id}', 'saveTranslation')->name('general.domains.saveTranslation')->middleware('can:TRANSLATE_DOMAIN');
            Route::get('/translation/del/{id}', 'delLang')->name('general.domains.delTranslation')->middleware('can:TRANSLATE_DOMAIN');
            Route::get('/by-tax-rate/{taxRateId}', 'getByTaxRateId')->name('general.domains.byTaxRate')->middleware('can:VIEW_DOMAINS');
            Route::get('/changes/{id}', 'getAllChanges')->name('general.domains.changes')->middleware('can:VIEW_DOMAINS');
        });

        Route::prefix('tax-rate')->controller(TaxRateController::class)->group(function () {
            Route::get('/', 'index')->name('general.tax_rate.index')->middleware('can:VIEW_TAXES');
            Route::get('/show/{id}', 'show')->name('general.tax_rate.show')->middleware('can:VIEW_TAXES');
            Route::post('/create', 'store')->name('general.tax_rate.create')->middleware('can:ADD_TAX');
            Route::post('/update', 'update')->name('general.tax_rate.update')->middleware('can:EDIT_TAX');
            Route::post('/delete', 'destroy')->name('general.tax_rate.delete')->middleware('can:DELETE_TAX');
            Route::get('/active', 'getActive')->name('general.tax_rate.getActive');
            Route::get('/currency-tree', 'getCurrencyWithTree')->name('general.tax_rate.currency-tree');
            Route::get('/by-currency/{currencyId}', 'getByCurrency')->name('general.tax_rate.byCurrency');
            Route::post('/translation/{id}', 'saveTranslation')->name('general.tax_rate.saveTranslation')->middleware('can:TRANSLATE_TAX');
            Route::get('/translation/{id}', 'getTranslation')->name('general.tax_rate.getTranslation')->middleware('can:TRANSLATE_TAX');
            Route::get('/translation/del/{id}', 'delLang')->name('general.tax_rate.delTranslation')->middleware('can:TRANSLATE_TAX');
            Route::get('/changes/{id}', 'getAllChanges')->name('general.tax_rate.changes')->middleware('can:VIEW_TAXES');
        });

        Route::prefix('settings')->controller(\App\Http\Controllers\General\SettingsController::class)->group(function () {
            Route::get('/', 'index')->name('general.settings.index');
            Route::get('/enums', 'getEnums')->name('general.settings.enums');
            Route::get('/show/{key}', 'show')->name('general.settings.show');
            Route::post('/create', 'store')->name('general.settings.create');
            Route::post('/save', 'update')->name('general.settings.update');
        });

        Route::prefix('constraints')->controller(ConstraintController::class)->group(function () {
            Route::get('/', 'index')->name('accounting.constraints.index');
            Route::get('/show/{id}', 'show')->name('accounting.constraints.show')->withoutMiddleware('ensure.auth');
            Route::post('/create', 'store')->name('accounting.constraints.create');
            Route::post('/update', 'update')->name('accounting.constraints.update');
            Route::post('/delete', 'destroy')->name('accounting.constraints.delete');
            Route::post('/delete-attachments', 'deleteAttachments')->name('accounting.constraints.attachment.delete');
            Route::get('/next-document-number/{type}', 'getNextDocumentNumber')->name('accounting.constraints.nextDocumentNumber');
            Route::post('/activate/{id}', 'activate')->name('accounting.constraints.activate');
            Route::get('/entries/{id}', 'getConstriantByid')->name('accounting.constraints.getConstriantByid');
            Route::get('/entries/{id}/print', 'print')->name('accounting.constraints.print');
            Route::get('/dailyentries/{id}/print', 'printDailyConstraint')->name('accounting.constraints.printDailyConstraint')->withoutMiddleware('ensure.auth');
        });
        Route::prefix('cost-centers')->controller(CostCenterController::class)->group(function () {
            Route::get('/', 'index')->name('accounting.cost-centers.index')->middleware('can:VIEW_COST_CENTERS');
            Route::get('/all', 'all')->name('accounting.cost-centers.all')->middleware('can:VIEW_COST_CENTERS');
            Route::get('/parents', 'parents')->name('accounting.cost-centers.parents')->middleware('can:VIEW_COST_CENTERS');
            Route::get('/by-parent/{id}', 'byParent')->name('accounting.cost-centers.by-parent')->middleware('can:VIEW_COST_CENTERS');
            Route::get('/show/{id}', 'show')->name('accounting.cost-centers.show')->middleware('can:VIEW_COST_CENTERS');
            Route::get('/next-serial/{id}', 'getNextSerial')->name('accounting.cost-centers.next-serial')->middleware('can:VIEW_COST_CENTERS');
            Route::post('/create', 'store')->name('accounting.cost-centers.create')->middleware('can:ADD_COST_CENTER');
            Route::post('/update', 'update')->name('accounting.cost-centers.update')->middleware('can:EDIT_COST_CENTER');
            Route::post('/delete', 'destroy')->name('accounting.cost-centers.delete')->middleware('can:DELETE_COST_CENTER');
        });
        Route::prefix('invoices')->controller(\App\Http\Controllers\Accounting\InvoiceController::class)->group(function () {
            Route::get('/', 'index')->name('accounting.invoices.index');
            Route::get('/show/{id}', 'show')->name('accounting.invoices.show');
            Route::get('/show-with-services/{id}', 'showWithServices')->name('accounting.invoices.show-with-services')->withoutMiddleware('ensure.auth');
            Route::get('/by-profile/{profileId}', 'getByProfile')->name('accounting.invoices.by-profile');
            Route::get('/by-next-date', 'getByNextDate')->name('accounting.invoices.by-next-date');
            Route::post('/create', 'store')->name('accounting.invoices.create');
            Route::post('/update', 'update')->name('accounting.invoices.update');
            Route::post('/delete', 'destroy')->name('accounting.invoices.delete');
        });
        Route::prefix('constraints/transfers/reports')->controller(ReportController::class)->group(function () {
            Route::get('/', 'dailyReport')->name('accounting.constraints.transfers.reports.dailyReport')->withoutMiddleware('ensure.auth');
            Route::get('/balance-Income', 'balanceAndIncome')->name('accounting.constraints.transfers.reports.balance.income')->withoutMiddleware('ensure.auth');
            Route::get('/trail-balance', 'trailBalance')->name('accounting.constraints.transfers.reports.trail.balance')->withoutMiddleware('ensure.auth');
            Route::post('/account-balance', 'accountTransfers')->name('accounting.constraints.transfers.reports.accountTransfers')->withoutMiddleware('ensure.auth');
            Route::post('/ledger', 'ledgerReport')->name('accounting.constraints.transfers.reports.ledgerReport')->withoutMiddleware('ensure.auth');
            Route::post('/cost-center', 'costCenterReport')->name('accounting.constraints.transfers.reports.costCenterReport')->withoutMiddleware('ensure.auth');
            Route::post('/employeecashboxstatement', 'getEmployeeCashboxStatement')->name('accounting.constraints.transfers.reports.employeecashboxstatement')->withoutMiddleware('ensure.auth');
            Route::post('/employeepaymentvouchers', 'EmployeePaymentVouchers')->name('accounting.constraints.transfers.reports.employeepaymentvouchers')->withoutMiddleware('ensure.auth');
            Route::post('/getemployeeinvoicereport', 'getEmployeeInvoiceReport')->name('accounting.constraints.transfers.reports.employeeinvoicevouchers')->withoutMiddleware('ensure.auth');
        });
    });

    Route::prefix('accommodation')->group(function () {
        Route::pattern('limit', '[0-9]+');
        Route::pattern('id', '[0-9]+');

        Route::controller(AccommodationsController::class)->group(function () {
            Route::get('/', 'index')->name('accommodation.accommodations');
            Route::get('/show/{id}', 'show')->name('accommodation.accommodations.show');
            Route::post('/create', 'store')->name('accommodation.accommodations.create');
            Route::post('/update', 'update')->name('accommodation.accommodations.update');
            Route::post('/delete', 'destroy')->name('accommodation.accommodations.delete');
            Route::get('/active', 'getActive')->name('accommodation.accommodations.getActive');
            Route::get('/type/{type}/city/{city_id}', 'getByType')->name('accommodation.accommodations.getByType');
            Route::post('/translation/{id}', 'saveTranslation')->name('accommodation.accommodations.saveTranslation');
            Route::get('/translation/{id}', 'getTranslation')->name('accommodation.accommodations.getTranslation');
            Route::get('/translation/del/{id}', 'delLang')->name('accommodation.accommodations.delTranslation');
            Route::get('/changes/{id}', 'getAllChanges')->name('accommodation.accommodations.changes');
        });

        Route::prefix('extras')->controller(ExtraController::class)->group(function () {
            Route::get('/', 'index')->name('accommodation.extras');
            Route::get('/show/{id}', 'show')->name('accommodation.extras.show');
            Route::post('/create', 'store')->name('accommodation.extras.create');
            Route::post('/update', 'update')->name('accommodation.extras.update');
            Route::post('/delete', 'destroy')->name('accommodation.extras.delete');
            Route::get('/active', 'getActive')->name('accommodation.extras.active');
            Route::post('/translation/{id}', 'SaveTranslation')->name('accommodation.extras.SaveTranslation');
            Route::get('/translation/{id}', 'getTranslation')->name('accommodation.extras.getTranslation');
            Route::get('/translation/del/{id}', 'delLang')->name('accommodation.extras.delTranslation');
            Route::get('/changes/{id}', 'getAllChanges')->name('accommodation.extras.changes');
        });
        Route::prefix('meal-plans')->controller(MealPlanesController::class)->group(function () {
            Route::get('/', 'index')->name('accommodation.meal-plans')->middleware('can:VIEW_MEALS_PLANS');
            Route::get('/show/{id}', 'getByid')->name('accommodation.meal-plans.show')->middleware('can:VIEW_MEALS_PLANS');
            Route::post('/create', 'create')->name('accommodation.meal-plans.create')->middleware('can:ADD_MEAL_PLAN');
            Route::post('/update', 'update')->name('accommodation.meal-plans.update')->middleware('can:EDIT_MEAL_PLAN');
            Route::get('/active', 'getActive')->name('accommodation.meal-plans.active');
            Route::post('/delete', 'destroy')->name('accommodation.meal-plans.delete')->middleware('can:DELETE_MEAL_PLAN');
            Route::post('/translation/{id}', 'SaveTranslation')->name('accommodation.meal-plans.SaveTranslation')->middleware('can:TRANSLATE_MEAL_PLAN');
            Route::get('/translation/{id}', 'getTranslation')->name('accommodation.meal-plans.getTranslation')->middleware('can:TRANSLATE_MEAL_PLAN');
            Route::get('/translation/del/{id}', 'delLang')->name('accommodation.meal-plans.delTranslation')->middleware('can:TRANSLATE_MEAL_PLAN');
            Route::get('/changes/{id}', 'getAllChanges')->name('accommodation.meal-plans.changes')->middleware('can:VIEW_MEALS_PLANS');
        });
        Route::prefix('rating')->controller(RatingContoller::class)->group(function () {
            Route::get('/', 'index')->name('accommodation.meal-plans')->middleware('can:VIEW_RATINGS');
            Route::get('/show/{id}', 'getByid')->name('accommodation.extras.show')->middleware('can:VIEW_RATINGS');
            Route::post('/create', 'create')->name('accommodation.extras.create')->middleware('can:ADD_RATE');
            Route::post('/update', 'update')->name('accommodation.extras.update')->middleware('can:EDIT_RATE');
            Route::post('/delete', 'destroy')->name('accommodation.extras.delete')->middleware('can:DELETE_RATE');
            Route::get('/active', 'getActive')->name('accommodation.extras.getActive');
            Route::post('/translation/{id}', 'SaveTranslation')->name('accommodation.extras.SaveTranslation')->middleware('can:TRANSLATE_RATE');
            Route::get('/translation/{id}', 'getTranslation')->name('accommodation.extras.getTranslation')->middleware('can:TRANSLATE_RATE');
            Route::get('/translation/del/{id}', 'delLang')->name('accommodation.extras.delTranslation')->middleware('can:TRANSLATE_RATE');
            Route::get('/changes/{id}', 'getAllChanges')->name('accommodation.rating.changes')->middleware('can:VIEW_RATINGS');
        });
        Route::prefix('room-types')->controller(RoomTypesController::class)->group(function () {
            Route::get('/', 'index')->name('accommodation.room-types.index')->middleware('can:VIEW_ROOM_TYPES');
            Route::get('/show/{id}', 'getByid')->name('accommodation.room-types.show')->middleware('can:VIEW_ROOM_TYPES');
            Route::post('/create', 'create')->name('accommodation.room-types.create')->middleware('can:ADD_ROOM_TYPE');
            Route::post('/update', 'update')->name('accommodation.room-types.update')->middleware('can:EDIT_ROOM_TYPE');
            Route::post('/delete', 'destroy')->name('accommodation.room-types.delete')->middleware('can:DELETE_ROOM_TYPE');
            Route::get('/active', 'getActive')->name('accommodation.room-types.getActive');
            Route::post('/translation/{id}', 'saveTranslation')->name('accommodation.room-types.saveTranslation')->middleware('can:TRANSLATE_ROOM_TYPE');
            Route::get('/translation/{id}', 'getTranslation')->name('accommodation.room-types.getTranslation')->middleware('can:TRANSLATE_ROOM_TYPE');
            Route::get('/translation/del/{id}', 'delLang')->name('accommodation.room-types.delTranslation')->middleware('can:TRANSLATE_ROOM_TYPE');
            Route::get('/changes/{id}', 'getAllChanges')->name('accommodation.room-types.changes')->middleware('can:VIEW_ROOM_TYPES');
        });
        Route::prefix('room-view')->controller(RoomViewController::class)->group(function () {
            Route::get('/', 'index')->name('accommodation.meal-plans')->middleware('can:VIEW_ROOM_VIEWS');
            Route::get('/show/{id}', 'getByid')->name('accommodation.extras.show')->middleware('can:VIEW_ROOM_VIEWS');
            Route::post('/create', 'create')->name('accommodation.extras.create')->middleware('can:ADD_ROOM_VIEW');
            Route::post('/update', 'update')->name('accommodation.extras.update')->middleware('can:EDIT_ROOM_VIEW');
            Route::post('/delete', 'destroy')->name('accommodation.roomviews.delete')->middleware('can:DELETE_ROOM_VIEW');
            Route::get('/active', 'getActive')->name('accommodation.roomviews.getActive');
            Route::post('/translation/{id}', 'saveTranslation')->name('accommodation.roomviews.saveTranslation')->middleware('can:TRANSLATE_ROOM_VIEW');
            Route::get('/translation/{id}', 'getTranslation')->name('accommodation.roomviews.getTranslation')->middleware('can:TRANSLATE_ROOM_VIEW');
            Route::get('/translation/del/{id}', 'delLang')->name('accommodation.roomviews.delTranslation')->middleware('can:TRANSLATE_ROOM_VIEW');
            Route::get('/changes/{id}', 'getAllChanges')->name('accommodation.room-views.changes')->middleware('can:VIEW_ROOM_VIEWS');
        });
    });

    Route::prefix('profile')->group(function () {
        Route::pattern('limit', '[0-9]+');
        Route::pattern('id', '[0-9]+');

        Route::controller(ProfileController::class)->group(function () {
            Route::get('/', 'index')->name('profiles');
            Route::get('/show/{id}', 'show')->name('profiles.show');
            Route::post('/create', 'store')->name('profiles.create');
            Route::post('/update', 'update')->name('profiles.update');
            Route::post('/delete', 'destroy')->name('profiles.delete');
            Route::get('/active', 'getActive')->name('profiles.getActive');
            Route::get('/test/{id}', 'getChangesPerCol');
            Route::get('/test-audit/{id}', 'testAuditCreation');
            Route::get('/track-percentage/{id}', 'trackPercentageChanges');
            Route::get('/changed-columns/{id}', 'getChangedColumns');
            Route::get('/column-changes/{id}/{columnName}', 'getColumChanges')->name('profiles.columnChanges');
            Route::get('/changes/{id}', 'getAllChanges');
            Route::get('/check/profile/reservation/{id}', 'checkReservation');
            Route::get('/invoice/{code}', 'getProfileShare')->withoutMiddleware('ensure.auth');
            Route::get('/make/invoice/{id}', 'invoiceProfile');
            Route::get('/get/all/note/{id}', 'ProfileNotes');
            Route::get('/get/currency/by/invoice/{id}', 'getCurrencyByInvoice');
        });

        Route::prefix('travelers')->controller(TravelerController::class)->group(function () {
            Route::get('/', 'index')->name('profile.travelers');
            Route::get('/show/{id}', 'show')->name('profile.travelers.show');
            Route::post('/delete', 'destroy')->name('profile.travelers.delete');
            Route::post('/create', 'createMultiple')->name('profile.travelers.createMultiple');
            Route::post('/update', 'updateMultiple')->name('profile.travelers.updateMultiple');
            Route::get('/changes/{id}', 'getAllChanges')->name('profile.travelers.changes');
            Route::get('/all-nationalities/{id}', 'getTravelerNationalitiesByProfile')->name('profile.travelers.nationalities');
        });

        // Customer Profiles Routes

        Route::prefix('customers')->controller(CustomerController::class)->group(function () {
            Route::get('/', 'index')->name('profile.customers');
            Route::get('/show/{id}', 'show')->name('profile.customers.show');
            Route::post('/create', 'store')->name('profile.customers.create');
            Route::post('/update', 'update')->name('profile.customers.update');
            Route::post('/delete', 'destroy')->name('profile.customers.delete');
            Route::get('/active', 'getActive')->name('profile.customers.getActive');
            Route::get('/changes/{id}', 'getAllChanges')->name('profile.customers.changes');

            Route::prefix('customer-profiles')->controller(\App\Http\Controllers\Profile\CustomerProfilesController::class)->group(function () {
                Route::post('/customer', 'getCustomerProfiles')->name('profile.customer-profiles.customer');
                Route::get('/profile/{profileId}', 'getProfileDetails')->name('profile.customer-profiles.profile');
                Route::post('/account-statement', 'getCustomerAccountStatement')->name('profile.customer-profiles.account-statement');
                Route::get('/financial-summary/{customerId}', 'getCustomerFinancialSummary')->name('profile.customer-profiles.financial-summary');
                Route::post('/invoice-balances', 'getCustomerInvoiceBalances')->name('profile.customer-profiles.invoice-balances');
                Route::post('/wallet', 'wallet')->name('profile.customer-profiles.wallet');
                Route::post('/wallet/transactions', 'getCustomerWalletTransactions');
                Route::post('/wallet/balance', 'getCustomerWalletBalanceV2');
                Route::post('/wallet/summary', 'getCustomersWalletSummary');
            });
        });

        Route::prefix('accommodation-reservations')->controller(\App\Http\Controllers\Profile\AccommodationReservationController::class)->group(function () {
            Route::get('/', 'index')->name('profile.accommodation_reservations');
            Route::get('/show/{id}', 'show')->name('profile.accommodation_reservations.show');
            Route::get('/type/{type}', 'getByAccommodationType')->name('profile.accommodation_reservations.byType');
            Route::get('/type/{type}/profile/{profileId}', 'getByAccommodationTypeAndProfile')->name('profile.accommodation_reservations.byTypeProfile');
            Route::post('/create', 'store')->name('profile.accommodation_reservations.create');
            Route::post('/update', 'update')->name('profile.accommodation_reservations.update');
            Route::post('/delete', 'destroy')->name('profile.accommodation_reservations.delete');
            Route::post('/add-attachment', 'reservationAttachments')->name('profile.accommodation_reservations.attachment');
            Route::post('/delete-attachments', 'deleteAttachment')->name('profile.accommodation_reservations.attachment.delete');
            Route::get('/attachments/profile/{profileId}', 'attachmentsByProfile')->name('profile.accommodation_reservations.attachments.byProfile');
            Route::get('/attachments/reservation/{reservationId}', 'attachmentsByReservation')->name('profile.accommodation_reservations.attachments.byReservation');
        });

        Route::prefix('accommodation-reservation-rooms')->controller(\App\Http\Controllers\Profile\AccommodationReservationRoomController::class)->group(function () {
            Route::get('/', 'index')->name('profile.accommodation_reservation_rooms');
            Route::get('/show/{id}', 'show')->name('profile.accommodation_reservation_rooms.show');
            Route::post('/create', 'store')->name('profile.accommodation_reservation_rooms.create');
            Route::post('/update', 'update')->name('profile.accommodation_reservation_rooms.update');
            Route::post('/delete', 'destroy')->name('profile.accommodation_reservation_rooms.delete');
            Route::get('/by-reservation/{id}', 'getAllByReservationId')->name('profile.accommodation_reservation_rooms.byReservation');
            Route::get('/changes/{id}/column/{columnName}', 'getColumChanges')->name('profile.accommodation_reservation_rooms.changes');
            Route::post('/change/status', 'status')->name('profile.accommodation_reservations.status');

        });

        Route::prefix('accommodation-reservation-prices')->controller(\App\Http\Controllers\Profile\AccommodationReservationPriceController::class)->group(function () {
            Route::get('/', 'index')->name('profile.accommodation_reservation_prices');
            Route::get('/show/{id}', 'show')->name('profile.accommodation_reservation_prices.show');
        });

        Route::prefix('daily-programs')->controller(\App\Http\Controllers\Profile\DailyProgramsController::class)->group(function () {
            Route::get('/show/{id}', 'show')->name('profile.daily_programs.show');
            Route::get('/by-profile/{profileId}', 'byProfile')->name('profile.daily_programs.byProfile');
            //  Route::post('/create', 'store')->name('profile.daily_programs.create');
            //  Route::post('/update', 'update')->name('profile.daily_programs.update');
        });

        // Invoice Services Routes
        Route::prefix('services')->group(function () {
            Route::controller(InvoiceServicesController::class)->group(function () {
                Route::get('/', 'index')->name('invoice-services.index');
                Route::get('/handling', 'getHandlingServices')->name('invoice-services-handling.index');
                Route::get('/handling-summary/{profileid}', 'getsummary')->name('invoice-services-handling.summary');
                Route::post('/create', 'store')->name('invoice-services.store');
                Route::get('show/{id}', 'show')->name('invoice-services.show');
                Route::post('/update', 'update')->name('invoice-services.update');
                Route::post('/delete', 'destroy')->name('invoice-services.destroy');
                Route::get('/profile/{profileId}/type/{type}', 'getByProfile')->name('invoice-services.getByProfile');
                Route::get('/daily/{daily_id}/type/{type}', 'getByDaily')->name('invoice-services.getByDaily');
                Route::get('/validation-rules/{serviceType}', 'getValidationRules')->name('invoice-services.validationRules');
                Route::get('/supported-types', 'getSupportedTypes')->name('invoice-services.supportedTypes');
                Route::get('/changes/{id}', 'getAllChanges')->name('invoice-services.changes');
                Route::get('/search', 'search')->name('invoice-services.search');
                Route::post('/paid/suppliers', 'paidSuppliers')->name('invoice-services.paidSuppliers');
                Route::post('/change/status', 'status')->name('invoice-services.status');
            });
            // Amadeus A.I.R. file upload
            Route::post('/amadeus-air/upload', [\App\Http\Controllers\Invoice\AmadeusAirController::class, 'uploadAirFile'])->name('invoice-services.amadeus-air.upload');
            Route::post('/amadeus-air/assign-profile', [\App\Http\Controllers\Invoice\AmadeusAirController::class, 'assignProfileToServices'])->name('invoice-services.amadeus-air.assignProfileToServices');
            Route::get('/amadeus-air/search', [\App\Http\Controllers\Invoice\AmadeusAirController::class, 'searchFlightsWithoutProfile'])->name('invoice-services.amadeus-air.searchFlightsWithoutProfile');
        });
    });

    Route::prefix('language')->group(function () {
        Route::controller(LagnuagesControllers::class)->group(function () {
            Route::get('/', 'index')->name('lang.index')->middleware('can:VIEW_LANGUAGES');
            Route::get('/active', 'getActive')->name('lang.active')->withoutMiddleware('ensure.auth');
            Route::get('/by/{id}', 'getByid')->name('lang.getByid')->middleware('can:VIEW_LANGUAGES');
            Route::post('add', 'add')->name('lang.add')->middleware('can:ADD_LANGUAGE');
            Route::post('updated', 'updated')->name('lang.updated')->middleware('can:EDIT_LANGUAGE');
            Route::get('get-country-code', 'getCountryCode')->name('lang.code')->middleware('can:VIEW_LANGUAGES');
        });
    });

    Route::prefix('supplier')->group(function () {
        Route::controller(SuppliersControllers::class)->group(function () {
            Route::get('/', 'index')->name('suppliers.index')->middleware('can:VIEW_SUPPLIERS');
            Route::get('/active', 'active')->name('suppliers.active');
            Route::get('/by/{id}', 'getByid')->name('suppliers.getByid')->middleware('can:VIEW_SUPPLIERS');
            Route::post('add', 'add')->name('supplier.add')->middleware('can:ADD_SUPPLIER');
            Route::post('updated', 'update')->name('suppliers.updated')->middleware('can:EDIT_SUPPLIER');
            Route::post('deleted', 'destroy')->name('suppliers.deleted')->middleware('can:DELETE_SUPPLIER');
            Route::get('getServices', 'supplierServicesNamed')->name('suppliers.supplierServicesNamed')->middleware('can:VIEW_SUPPLIERS');
            Route::post('/currency-tree', 'getCountryCode')->name('suppliers.code')->middleware('can:VIEW_SUPPLIERS');
            Route::post('/currency-tree/by-methods', 'getCurrencyByPaymentMethods')->name('suppliers.getCurrencyByPaymentMethods')->middleware('can:VIEW_SUPPLIERS');
            Route::post('/translation/{id}', 'saveTranslation')->name('suppliers.saveTranslation')->middleware('can:TRANSLATE_SUPPLIER');
            Route::get('/translation/{id}', 'getTranslation')->name('suppliers.getTranslation')->middleware('can:TRANSLATE_SUPPLIER');
            Route::get('/translation/del/{id}', 'delLang')->name('suppliers.delTranslation')->middleware('can:TRANSLATE_SUPPLIER');
            Route::get('/service/{serviceId}/currency/{currencyId}', 'suppliersByServiceAndCurrency')->name('suppliers.byService.byCurrencies');
            Route::get('/accommodation/{accommodationId}', 'SupplierByAccommodation')->name('suppliers.ByAccommodation');
            Route::get('/summary/{id}', 'supplierSummary')->name('suppliers.supplierSummary')->middleware('can:VIEW_SUPPLIERS');
        });
    });

    Route::prefix('accounting')->group(function () {
        Route::controller(TreeAccountingController::class)->group(function () {
            Route::get('/', 'list')->name('tree.index')->middleware('can:VIEW_ACCOUNTING_MANUAL');
            Route::get('/get-all', 'getAll')->name('tree.getAll')->middleware('can:VIEW_ACCOUNTING_MANUAL');
            Route::get('/get/by/currency/{id}', 'getByCurrency')->name('tree.getByCurrency')->middleware('can:VIEW_ACCOUNTING_MANUAL');
            Route::get('/get/banks/currency/{id}', 'getBanksByCurrency')->name('tree.getBanksByCurrency')->middleware('can:VIEW_ACCOUNTING_MANUAL');
            Route::get('/serial/parent/{id}', 'getSerialNumber')->name('tree.getSerialNumber')->middleware('can:VIEW_ACCOUNTING_MANUAL');
            Route::post('/validate/serial', 'validateSerial')->name('tree.validateSerial')->middleware('can:EDIT_ACCOUNTING_MANUAL');
            Route::post('/create', 'create')->name('tree.create')->middleware('can:ADD_ACCOUNTING_MANUAL');
            Route::post('/update', 'updateBasic')->name('tree.updateBasic')->middleware('can:EDIT_ACCOUNTING_MANUAL');
            Route::get('/parents', 'parents')->name('tree.parents')->middleware('can:VIEW_ACCOUNTING_MANUAL');
            Route::get('/active', 'active')->name('tree.active');
            Route::get('/active/setting', 'getActiveSetting')->name('tree.getActiveSetting');
            Route::get('/by-parent/{parentId}', 'byParent')->name('tree.byParent')->middleware('can:VIEW_ACCOUNTING_MANUAL');
            Route::get('/show/{id}', 'show')->name('tree.show')->middleware('can:VIEW_ACCOUNTING_MANUAL');
            Route::post('/translation/{id}', 'saveTranslation')->name('tree.saveTranslation')->middleware('can:EDIT_ACCOUNTING_MANUAL');
            Route::get('/translation/{id}', 'getTranslation')->name('tree.getTranslation')->middleware('can:VIEW_ACCOUNTING_MANUAL');
            Route::get('/translation/del/{id}', 'delLang')->name('tree.delTranslation')->middleware('can:EDIT_ACCOUNTING_MANUAL');
        });

        Route::prefix('settings')->controller(TreeAccountSettingController::class)->group(function () {
            Route::post('/tree-account-settings', 'update')->name('tree.settings.update')->middleware('can:CHANGE_ACCOUNTING_MANUAL_SETTINGS');
            Route::get('/get-all', 'getAll')->name('tree.settings.getAll')->middleware('can:CHANGE_ACCOUNTING_MANUAL_SETTINGS');
        });

        Route::prefix('paytype')->controller(\App\Http\Controllers\Accounting\PaytypeController::class)->group(function () {
            Route::get('/', 'index')->name('accounting.paytype')->middleware('can:VIEW_PAYMENT_METHODS');
            Route::get('/active', 'getActive')->name('accounting.paytype.active');
            Route::get('/show/{id}', 'show')->name('accounting.paytype.show')->middleware('can:VIEW_PAYMENT_METHODS');
            Route::get('/paid-supplier', 'getToSupplierPaid')->name('accounting.paytype.getToSupplierPaid')->middleware('can:VIEW_PAYMENT_METHODS');
            Route::post('/create', 'store')->name('accounting.paytype.create')->middleware('can:ADD_PAYMENT_METHOD');
            Route::post('/update', 'update')->name('accounting.paytype.update')->middleware('can:EDIT_PAYMENT_METHOD');
            Route::post('/delete', 'destroy')->name('accounting.paytype.delete')->middleware('can:DELETE_PAYMENT_METHOD');
            Route::get('/currency/{id}', 'getByCurrency')->name('accounting.paytype.getByCurrency')->withoutMiddleware('ensure.auth');
            Route::post('/translation/{id}', 'SaveTranslation')->name('accounting.paytype.saveTranslation')->middleware('can:TRANSLATE_PAYMENT_METHOD');
            Route::get('/translation/{id}', 'getTranslation')->name('accounting.paytype.getTranslation')->middleware('can:TRANSLATE_PAYMENT_METHOD');
            Route::get('/translation/del/{id}', 'delLang')->name('accounting.paytype.delTranslation')->middleware('can:TRANSLATE_PAYMENT_METHOD');
            Route::get('/changes/{id}', 'getAllChanges')->name('accounting.paytype.changes')->middleware('can:VIEW_PAYMENT_METHODS');
        });
        Route::prefix('unposted_collections')->controller(\App\Http\Controllers\Accounting\UnpostedCollectionsControllers::class)->group(function () {
            Route::get('/profile/{id}', 'getBypofile')->name('unposted_collections.getBypofile');
            Route::post('/create', 'add')->name('unposted_collections.add');
            Route::post('/update', 'update')->name('unposted_collections.update');
            Route::post('/check-amount', 'checkAmount')->name('unposted_collections.checkAmount');
            Route::get('/summary/{id}', 'summary')->name('unposted_collections.summary');
            Route::get('/currency/profile/{id}', 'selectedCurrency')->name('unposted_collections.selectedCurrency');
        });
    });

    Route::prefix('roles_groups')->group(function () {
        Route::prefix('roles')->group(function () {
            Route::controller(RoleController::class)->group(function () {
                Route::get('/', 'index')->name('Roles.index')->middleware('can:VIEW_USER_ROLES');
                Route::get('show/{id}', 'show')->name('Role.getByid')->middleware('can:VIEW_USER_ROLES');
                Route::get('/permissionInside', 'getPermissions')->name('Role.Permissions')->middleware('can:VIEW_USER_ROLES');
                Route::post('/', 'store')->name('Role.add')->middleware('can:ADD_USER_ROLE');
                Route::post('updated/{id}', 'update')->name('Roles.updated')->middleware('can:EDIT_USER_ROLE');
                Route::get('deleted/{id}', 'destroy')->name('Roles.deleted')->middleware('can:DELETE_USER_ROLE');
                Route::post('assign-permissions/{roleid}', 'updatePermissions')->name('Roles.assignPermissions')->middleware('can:EDIT_USER_ROLE');
            });
        });
        Route::prefix('groups')->group(function () {
            Route::controller(GroupController::class)->group(function () {
                Route::get('/', 'index')->name('Groups.index');
                Route::get('/show/{id}', 'show')->name('Groups.getByid');
            });
        });

        Route::prefix('permissions')->group(function () {
            Route::controller(PermissionController::class)->group(function () {
                Route::get('/', 'index')->name('permission.index');
                Route::get('/show/{id}', 'show')->name('permission.getByid');
                Route::get('/unique_permissions_names', 'getUniqueControllerNames')->name('permission.uniqueControllerNames');
                Route::get('/groupedby/{controllername}', 'getPermissionsByController')->name('permission.methodsByController');
                Route::get('/my-permissions', 'myPermissions')->name('permission.myPermissions')->middleware('ensure.auth');
                Route::post('/', 'store')->name('permission.add');
                Route::post('updated/{id}', 'update')->name('permission.updated');
                Route::get('deleted/{id}', 'delete')->name('permission.deleted');
            });
        });
    });
    Route::prefix('user')->group(function () {
        Route::controller(UserController::class)->group(function () {
            Route::get('/', 'index')->name('User.index');
            Route::get('/show/{id}', 'show')->name('User.getByid')->middleware('can:VIEW_USERS');
            Route::post('/', 'store')->name('user.add')->middleware('can:ADD_USER');
            Route::post('updated/{id}', 'update')->name('User.updated')->middleware('can:EDIT_USER');
            Route::get('deleted/{id}', 'destroy')->name('User.deleted')->middleware('can:DELETE_USER');
            Route::post('assign-roles/{userid}', 'updateuserrole')->name('User.updateuserrole')->middleware('can:EDIT_USER_ROLE');
            Route::post('UpdateUserPermissions/{userid}', 'updateOverrides')->name('User.updateOverrides')->middleware('can:EDIT_USER_ROLE');
            Route::get('wallet-report/{id}', 'walletReport')->name('User.walletReport');
            Route::post('wallet', 'wallet')->name('User.wallet');
            Route::post('wallet/transactions', 'walletTransactions')->name('User.walletTransactions');
        });
    });
    Route::prefix('notifications')->controller(\App\Http\Controllers\Notification\NotificationController::class)->group(function () {
        Route::pattern('id', '[0-9a-fA-F\-]+');
        Route::get('/', 'index')->name('notifications.index');
        Route::get('/unread', 'unread')->name('notifications.unread');
        Route::get('/unread-count', 'unreadCount')->name('notifications.unread-count');
        Route::get('/read/{id}', 'markAsRead')->name('notifications.mark-as-read');
        Route::get('/mark-all-read', 'markAllAsRead')->name('notifications.mark-all-read');
        // Route::get('/{id}', 'show')->name('notifications.show');
        Route::delete('delete/{id}', 'destroy')->name('notifications.destroy');
    });
});

// Broadcasting Auth Route - مطلوب للـ WebSocket authentication مع Reverb
Route::post('/broadcasting/auth', function (\Illuminate\Http\Request $request) {
    return \Illuminate\Support\Facades\Broadcast::auth($request);
})->middleware(['ensure.auth'])->name('broadcasting.auth');
Route::prefix('auth')->group(function () {
    Route::controller(AuthController::class)->group(function () {
        Route::post('/login', 'Login')->name('user.login');
        Route::post('/refresh', 'refresh')->name('user.refresh');
        Route::middleware('ensure.auth')->group(function () {
            Route::post('/logout', 'logout')->name('user.logout');
            Route::get('/me', 'me')->name('user.me');
            Route::post('/changePassword ', 'changePassword')->name('user.changePassword');
        });
    });
});

// Config endpoints (public - للـ frontend)
Route::prefix('config')->controller(\App\Http\Controllers\Config\ConfigController::class)->group(function () {
    Route::get('/reverb', 'reverbConfig')->name('config.reverb');
});

// Test Notification Route - لاختبار push notifications على public channel
Route::middleware('ensure.auth')->group(function () {
    Route::get('/test/notification', function (\Illuminate\Http\Request $request) {
        $notificationService = app(\App\sys\Services\Notification\NotificationService::class);

        $channel = $request->query('channel', 'public');
        $title = $request->query('title', 'Test Notification');
        $message = $request->query('message', 'هذه رسالة تجريبية للتحقق من عمل الإشعارات');

        $result = $notificationService->sendNotification([
            'channel' => $channel,
            'type' => 'system_event',
            'title' => $title,
            'message' => $message,
            'model_name' => 'Test',
            'model_id' => null,
            'sender_by' => auth('api')->id(),
            'data' => [
                'test' => true,
                'timestamp' => now()->toDateTimeString(),
            ],
        ]);

        if (! $result) {
            $errors = $notificationService->errors();

            return response()->json([
                'status' => 400,
                'message' => 'error',
                'errors' => $errors,
            ], 400);
        }

        return response()->json([
            'status' => 200,
            'message' => 'success',
            'data' => [
                'message' => 'تم إرسال الإشعار بنجاح لجميع المشتركين في القناة',
                'channel' => $channel,
                'title' => $title,
                'message_text' => $message,
            ],
        ], 200);
    })->name('test.notification');
});

// Test Notification Route بدون authentication (للتطوير فقط - احذفها في Production)
Route::get('/test/notification/public', function () {
    $notificationService = app(\App\sys\Services\Notification\NotificationService::class);

    $result = $notificationService->sendNotification([
        'channel' => 'public',
        'type' => 'system_event',
        'title' => 'Test Notification',
        'message' => 'هذه رسالة تجريبية للتحقق من عمل الإشعارات',
        'model_name' => 'Test',
        'model_id' => null,
        'sender_by' => 1, // Default user ID
        'data' => [
            'test' => true,
            'timestamp' => now()->toDateTimeString(),
        ],
    ]);

    if (! $result) {
        $errors = $notificationService->errors();

        return response()->json([
            'status' => 400,
            'message' => 'error',
            'errors' => $errors,
        ], 400);
    }

    return response()->json([
        'status' => 200,
        'message' => 'success',
        'data' => [
            'message' => 'تم إرسال الإشعار بنجاح لجميع المشتركين في القناة public',
            'channel' => 'public',
            'title' => 'Test Notification',
            'message_text' => 'هذه رسالة تجريبية للتحقق من عمل الإشعارات',
        ],
    ], 200);
})->name('test.notification.public');

Route::prefix('translations')->controller(TranslationController::class)->group(function () {
    Route::get('get/{language_id}', 'index')->name('general.translations.index');
    Route::get('/controllers', 'getControllerNames')->name('general.translations.controllers');
    Route::post('/bulk-update', 'bulkUpdate')->name('general.translations.bulk-update');
    Route::get('/show/{id}', 'show')->name('general.translations.show');
    Route::post('/add_new_key', 'store')->name('general.translations.add_new_key');
    Route::post('/update/{id}', 'update')->name('general.translations.update');
    Route::post('/delete/{id}', 'destroy')->name('general.translations.delete');
    Route::get('/get/lang/{id}', 'getLang');
});
