<?php

namespace App\Http\Controllers\Accounting;

use App\Http\Controllers\Controller;
use App\Http\Resources\Accounting\TreeAccountSettingResource;
use App\sys\ApiResponse;
use App\sys\Services\Accounting\TreeAccountSettingServices;
use Illuminate\Http\Request;

class TreeAccountSettingController extends Controller
{
    use ApiResponse;

    private $treeAccountSettingServices;

    public function __construct()
    {
        $this->treeAccountSettingServices = new TreeAccountSettingServices;
    }

    public function update(Request $request)
    {
        $settings = $this->treeAccountSettingServices->update($request->all());

        if (! $settings) {
            $errors = $this->treeAccountSettingServices->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        return $this->apiResponse(200, 'success', null, TreeAccountSettingResource::collection($settings));
    }

    public function getAll()
    {
        $settings = $this->treeAccountSettingServices->getAll();

        return $this->apiResponse(200, 'success', null, TreeAccountSettingResource::collection($settings));
    }
}
