<?php

namespace App\Http\Resources\Accommodation\MealPlan;

use Illuminate\Http\Resources\Json\JsonResource;

class MealPlanLangResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'meal_plan_id' => $this->meal_plan_id ?? null,
            'lang_id' => $this->lang_id ?? null,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'translations' => ($this->translations && $this->translations->isNotEmpty())
                ? MealPlanTranslationResource::collection($this->translations)
                : null,
        ];
    }
}
