<?php

namespace App\Http\Resources\Accounting;

use Illuminate\Http\Resources\Json\JsonResource;

class TreeAccountingResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'title' => $this->relationLoaded('currentTranslation') && $this->currentTranslation
                ? ($this->currentTranslation->title ?? $this->title)
                : $this->title,
            'description' => $this->relationLoaded('currentTranslation') && $this->currentTranslation
                ? ($this->currentTranslation->description ?? $this->description)
                : $this->description,
            'serial_number' => $this->serial_number,
            'serial_number_dight' => $this->serial_number_dight,
            'tree_accounting_id' => $this->tree_accounting_id,
            'tree_accounting_title' => $this->when($this->relationLoaded('parent') && $this->parent, function () {
                return $this->parent->relationLoaded('currentTranslation') && $this->parent->currentTranslation
                    ? ($this->parent->currentTranslation->title ?? $this->parent->title)
                    : $this->parent->title;
            }),
            'accounts_structure_id' => $this->accounts_structure_id,
            'accounts_structure_name' => $this->when($this->relationLoaded('structure') && $this->structure, function () {
                return $this->structure->title ?? null;
            }),
            'currency_id' => $this->currency_id,
            'currency_name' => $this->when($this->relationLoaded('currency') && $this->currency, function () {
                return $this->currency->relationLoaded('currentTranslation') && $this->currency->currentTranslation
                    ? ($this->currency->currentTranslation->name ?? $this->currency->name)
                    : $this->currency->name;
            }),
            'currency' => $this->when($this->relationLoaded('currency') && $this->currency, function () {
                return [
                    'id' => $this->currency->id,
                    'name' => $this->currency->relationLoaded('currentTranslation') && $this->currency->currentTranslation
                        ? ($this->currency->currentTranslation->name ?? $this->currency->name)
                        : $this->currency->name,
                    'symbol' => $this->currency->symbol,
                    'is_default' => $this->currency->status ?? false, // استخدام status كـ is_default
                    'exchange_rate' => $this->currency->exchange_rate,
                    'code' => $this->currency->code,
                ];
            }),
            'company_id' => $this->company_id,
            'company_name' => $this->when($this->relationLoaded('company') && $this->company, function () {
                return $this->company->relationLoaded('currentTranslation') && $this->company->currentTranslation
                    ? ($this->company->currentTranslation->name ?? $this->company->name)
                    : $this->company->name;
            }),
            'credit' => $this->credit,
            'debit' => $this->debit,
            'active' => $this->active,
            'has_child' => isset($this->children_count) ? $this->children_count > 0 : ($this->relationLoaded('children') ? $this->children->isNotEmpty() : false),
            'along_level' => $this->along_level,
            'the_level' => $this->the_level,
            'created_at' => $this->created,
            'updated_at' => $this->modified,
            'translations' => \App\Http\Resources\Accounting\TreeAccountingTranslationResource::collection($this->whenLoaded('translations')),
            'children' => \App\Http\Resources\Accounting\TreeAccountingResource::collection($this->whenLoaded('getAllChildren')),
        ];
    }
}
