<?php

namespace App\Http\Resources\General\Domain;

use Illuminate\Http\Resources\Json\JsonResource;

class DomainTranslationResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->title,
            'lang_id' => $this->lang_id,
            'lang_name' => $this->getLang->name ?? null,
            'lang_code' => $this->getLang->code ?? null,
            'domain_id' => $this->domain_id,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
