<?php

namespace App\Http\Resources\Invoice;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class AirlineTicketsResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'invoice_service_id' => $this->invoice_service_id,
            'company_id' => $this->company_id,
            'month' => $this->month,
            'issue_date' => $this->issue_date?->format('Y-m-d H:i:s'),
            'chair_num' => $this->chair_num,
            'flight_num' => $this->flight_num,
            'from_airline_id' => $this->from_airline_id,
            'to_airline_id' => $this->to_airline_id,
            'go_back' => $this->go_back,
            'from_airport_id' => $this->from_airport_id,
            'to_airport_id' => $this->to_airport_id,
            'ticket_num' => $this->ticket_num,
            'passport_num' => $this->passport_num,
            'economy_class' => $this->economy_class,
            'passenger_type' => $this->passenger_type,
            'passenger_name' => $this->passenger_name,
            'ticket_emd' => $this->ticket_emd,
            'emd_price' => $this->emd_price,
            'fare_price' => $this->fare_price,
            'tax' => $this->tax,
            'earned_discount' => $this->earned_discount,
            'granted_discount' => $this->granted_discount,
            'total_price' => $this->total_price,
            'pnr' => $this->pnr,
            'note' => $this->note,
            'created' => $this->created?->format('Y-m-d H:i:s'),
            'modified' => $this->modified?->format('Y-m-d H:i:s'),
            'from_airport_data' => $this->whenLoaded('fromAirport'),
            'to_airport_data' => $this->whenLoaded('toAirport'),
            'from_airline_data' => $this->whenLoaded('fromAirline'),
            'to_airline_data' => $this->whenLoaded('toAirline'),
            'company_data' => $this->whenLoaded('company'),
        ];
    }
}
