<?php

namespace App\Http\Resources\Notification;

use App\Models\User;
use Illuminate\Http\Resources\Json\JsonResource;

class NotificationResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray($request): array
    {
        $data = $this->data ?? [];
        $senderBy = $data['sender_by'] ?? null;
        $senderName = null;

        if ($senderBy) {
            $sender = User::find($senderBy);
            $senderName = $sender?->name;
        }

        return [
            'id' => $this->id,
            'type' => $data['type'] ?? null,
            'title' => $data['title'] ?? null,
            'message' => $data['message'] ?? null,
            'model_name' => $data['model_name'] ?? null,
            'model_id' => $data['model_id'] ?? null,
            'sender_by' => $senderBy,
            'sender_name' => $senderName,
            'data' => $data['data'] ?? [],
            'read_at' => $this->read_at?->toDateTimeString(),
            'created_at' => $this->created_at?->toDateTimeString(),
            'expires_at' => $this->expires_at?->toDateTimeString(),
        ];
    }
}
