<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class RoomTypesResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->relationLoaded('currentTranslation')
                ? ($this->currentTranslation->name ?? $this->name)
                : $this->name,
            'active' => $this->is_active,
            'occupancy' => $this->occupancy,
            'created_at' => $this->created,
            'updated_at' => $this->modified,
        ];
    }
}
