<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class ServicesCurrenciesResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'service_id' => $this->service_id,
            'currency_id' => $this->currency_id,
            'price' => $this->price,
            'tree_accounting_id' => $this->tree_accounting_id,
            'tree_income_accounting_id' => $this->tree_income_accounting_id,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'currency' => $this->whenLoaded('currency', function () {
                return new CurrencyResource($this->currency);
            }, null),

        ];
    }
}
