<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\ResourceCollection;

class TaxRateCollection extends ResourceCollection
{
    public function toArray($request)
    {
        $response = [
            'data' => TaxRateResource::collection($this->collection),
        ];
        if ($this->resource instanceof \Illuminate\Pagination\AbstractPaginator) {
            $response['links'] = $this->paginationLinks();
            $response['meta'] = [
                'pagination' => [
                    'total' => $this->total(),
                    'count' => $this->count(),
                    'per_page' => $this->perPage(),
                    'current_page' => $this->currentPage(),
                    'total_pages' => $this->lastPage(),
                ],
            ];
        }

        return $response;
    }

    protected function paginationLinks()
    {
        $paginator = $this->resource;

        $prevPage = $paginator->currentPage() - 1;
        $nextPage = $paginator->currentPage() + 1;

        $links = $nextPage <= $paginator->lastPage() ? $paginator->url($nextPage) : null;

        return $links;
    }
}
