<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class TaxRateResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->relationLoaded('currentTranslation')
                ? ($this->currentTranslation->title ?? $this->title)
                : $this->title,
            'percentage' => $this->percentage,
            'type' => $this->type,
            'active' => $this->is_active,
            'created_at' => $this->created,
            'updated_at' => $this->modified,
            'accounting' => $this->whenLoaded('accounting', function () {
                return TaxRateAccounting::collection($this->accounting);
            }),
        ];
    }
}
