<?php

namespace App\Models\General;

use App\Models\Suppliers\Suppliers;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Auditable as AuditableTrait;
use OwenIt\Auditing\Contracts\Auditable;

class Category extends Model implements Auditable
{
    use AuditableTrait;

    protected $table = 'categories';

    const CREATED_AT = 'created';

    const UPDATED_AT = 'modified';

    protected $fillable = [
        'title',
        'is_active',
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    /**
     * Attributes to audit
     */
    protected $auditInclude = [
        'title',
        'is_active',
    ];

    /**
     * Attributes to exclude from audit
     */
    protected $auditExclude = [
        'created',
        'modified',
    ];

    /**
     * Audit events to record
     */
    protected $auditEvents = [
        'updated',
    ];

    public function translations()
    {
        return $this->hasMany(CategoryTranslation::class, 'category_id');
    }

    public function currentTranslation()
    {
        return $this->hasOne(CategoryTranslation::class, 'category_id')
            ->where('lang_id', app('lang_id'));
    }

    public function suppliers()
    {
        return $this->belongsToMany(Suppliers::class, 'suppliers_categories', 'category_id', 'supplier_id');
    }
}
