<?php

namespace App\Models\General;

use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use OwenIt\Auditing\Auditable as AuditableTrait;
use OwenIt\Auditing\Contracts\Auditable;

class Companies extends Model implements Auditable
{
    use AuditableTrait, HasFactory, SoftDeletes;

    protected $appends = ['logo', 'doc'];

    const CREATED_AT = 'created';

    const UPDATED_AT = 'modified';

    protected $table = 'companies';

    protected $fillable = [
        'name_company',
        'companie_state',
        'companie_city',
        'companie_zip',
        'company_vat',
        'companie_country',
        'companie_phone',
        'companie_fax',
        'companie_mobile',
        'companie_email',
        'invoice_logo',
        'image_stamp_docs',
        'image_stamp_docs_x',
        'image_stamp_docs_y',
        'image_stamp_docs_size',
        'apear_stamp',
        'default_invoice_footer',
        'default_invoice_footer_en',
        'companie_address_1',
        'fund_account',
        'fund_account_cash',
        'bank_tree_account',
        'fund_hr',
        'deposit',
        'cach_custmer',
        'fund_hr_cash',
        'cost_center_id',
        'cost_center_id_cr',
        'issuer_type',
        'issuer_id',
        'issuer_name',
        'issuer_branch_id',
        'issuer_country',
        'issuer_governate',
        'issuer_region_city',
        'issuer_region_street',
        'issuer_building_number',
        'issuer_postal_code',
        'issuer_floor',
        'issuer_room',
        'issuer_landmark',
        'issuer_additional_information',
        'customers_payments',
        'is_active',
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    /**
     * Attributes to audit
     */
    protected $auditInclude = [
        'name_company',
        'companie_state',
        'companie_city',
        'companie_zip',
        'company_vat',
        'companie_country',
        'companie_phone',
        'companie_fax',
        'companie_mobile',
        'companie_email',
        'invoice_logo',
        'image_stamp_docs',
        'image_stamp_docs_x',
        'image_stamp_docs_y',
        'image_stamp_docs_size',
        'apear_stamp',
        'default_invoice_footer',
        'default_invoice_footer_en',
        'companie_address_1',
        'fund_account',
        'fund_account_cash',
        'bank_tree_account',
        'fund_hr',
        'deposit',
        'cach_custmer',
        'fund_hr_cash',
        'cost_center_id',
        'cost_center_id_cr',
        'issuer_type',
        'issuer_id',
        'issuer_name',
        'issuer_branch_id',
        'issuer_country',
        'issuer_governate',
        'issuer_region_city',
        'issuer_region_street',
        'issuer_building_number',
        'issuer_postal_code',
        'issuer_floor',
        'issuer_room',
        'issuer_landmark',
        'issuer_additional_information',
        'customers_payments',
        'is_active',
    ];

    /**
     * Attributes to exclude from audit
     */
    protected $auditExclude = [
        'created',
        'modified',
    ];

    /**
     * Audit events to record
     */
    protected $auditEvents = [
        'updated',
    ];

    public function accounting()
    {
        return $this->hasMany(CompanyAccountMappings::class, 'company_id')->with('currency', 'tree');
    }

    public function getLogoAttribute()
    {
        return $this->invoice_logo != null && file_exists(public_path().'/'.$this->invoice_logo) ? url($this->invoice_logo) : null;
    }

    public function getDocAttribute()
    {
        return $this->image_stamp_docs != null && file_exists(public_path().'/'.$this->image_stamp_docs) ? url($this->image_stamp_docs) : null;
    }

    public function translations()
    {
        return $this->hasMany(CompanyTranslation::class, 'company_id');
    }

    public function currentTranslation()
    {
        return $this->hasOne(CompanyTranslation::class, 'company_id')
            ->where('lang_id', app('lang_id'));
    }

    public function area()
    {
        return $this->belongsTo(Area::class, 'companie_state');
    }

    public function city()
    {
        return $this->belongsTo(City::class, 'companie_city');
    }

    public function country()
    {
        return $this->belongsTo(Country::class, 'companie_country');
    }

    public function users()
    {
        return $this->belongsToMany(User::class, 'company_user');
    }
}
