<?php

namespace App\Models\General;

use App\Models\Languages\Languages;
use Illuminate\Database\Eloquent\Model;

class DomainTranslation extends Model
{
    protected $table = 'domain_translation';

    protected $fillable = [
        'lang_id',
        'title',
        'domain_id',
        'created_at',
        'updated_at',
    ];

    public function getLang()
    {
        return $this->belongsTo(Languages::class, 'lang_id');
    }
}
