<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Permission extends Model
{
    protected $table = 'permissions';

    protected $fillable = [
        'permission_name',
        'Controller_name',
        'collection_name',
        'created_at',
        'updated_at',
    ];

    public function roles()
    {
        return $this->belongsToMany(Role::class, 'role_has_permissions')
            ->withPivot('function_name', 'collection_name');
    }

    public function usersWithOverrides()
    {
        return $this->belongsToMany(User::class, 'user_permission_overrides')
            ->withPivot('override_type', 'function_name', 'collection_name');
    }
}
