<?php

namespace App\Models\Profile;

use App\Models\Accommodation\Accommodations;
use App\Models\General\City;
use App\Models\Suppliers\Suppliers;
use Illuminate\Database\Eloquent\Model;

class AccommodationReservation extends Model
{
    protected $fillable = [
        'profile_id',
        'accommodation_id',
        'type',
        'status',
        'confirmation_date',
        'confirmation_num',
        'supplier_id',
        'city_id',
        'country_id',
        'customer_note',
        'hotel_note',
        'reservation_num',
        'reservation_link',
        'count_rooms',
        'payment_date',
    ];

    protected $table = 'pr_accommodation_reservation';

    public function profile()
    {
        return $this->belongsTo(Profile::class, 'profile_id');
    }

    public function accommodation()
    {
        return $this->belongsTo(Accommodations::class, 'accommodation_id');
    }

    public function rooms()
    {
        return $this->hasMany(AccommodationReservationRoom::class, 'reservation_id');
    }

    public function city()
    {
        return $this->belongsTo(City::class, 'city_id');
    }

    public function attachments()
    {
        return $this->morphMany(Attachment::class, 'attachable');
    }

    public function supplier()
    {
        return $this->belongsTo(Suppliers::class, 'supplier_id');
    }
}
