<?php

namespace App\Models\Profile;

use App\Models\General\TaxRate;
use Illuminate\Database\Eloquent\Model;

class AccommodationReservationRoomTax extends Model
{
    protected $table = 'pr_accommodation_reservation_room_tax';

    protected $fillable = [
        'tax_rate_id',                       // int(11) - رابط لجدول الضريبة
        'tax_amount',                        // double - مبلغ الضريبة المحسوب
        'tax_rate_amount',                   // double - نسبة الضريبة على المبلغ
        'currency_id',                       // bigint(20) UNSIGNED - العملة المستخدمة
        'accommodation_reservation_rooms_id', // bigint(20) UNSIGNED - رابط لغرفة الحجز
        'accommodation_reservation_id',      // bigint(20) UNSIGNED - رابط الحجز
        'profile_id',                         // int(11) - رابط الملف الشخصي للعميل
        'created_at',                         // timestamp - وقت الإنشاء
        'updated_at',                         // timestamp - وقت التحديث
    ];

    public function tax()
    {
        return $this->belongsTo(TaxRate::class, 'tax_rate_id');
    }
}
