<?php

namespace App\Models\Profile;

use Illuminate\Database\Eloquent\Model;

class Attachment extends Model
{
    protected $table = 'pr_attachments';

    protected $fillable = [
        'profile_id',
        'attachable_type',
        'attachable_id',
        'path',
    ];

    public function attachable()
    {
        return $this->morphTo();
    }

    public function profile()
    {
        return $this->belongsTo(Profile::class, 'profile_id');
    }
}
