<?php

namespace App\Models\Suppliers;

use App\Models\Accounting\TreeAccounting;
use App\Models\General\Currency;
use Illuminate\Database\Eloquent\Model;

class SupplierAccountMappings extends Model
{
    protected $table = 'su_supplier_account_mappings';

    public function currency()
    {
        return $this->belongsTo(Currency::class, 'currency_id');
    }

    public function tree()
    {
        return $this->belongsTo(TreeAccounting::class, 'tree_account_id');
    }
}
