<?php

namespace App\Observers;

use App\Models\Accounting\UnpostedCollections;
use App\sys\Enums\GroupEnum;
use App\sys\Services\Notification\NotificationService;

class UnpostedCollectionsObserver
{
    protected NotificationService $notificationService;

    /**
     * المجموعات المستهدفة بإشعارات الدفعات غير المرحلة
     */
    protected const TARGET_GROUPS = [
        GroupEnum::ADMIN,
        GroupEnum::ACCOUNTANT_MANAGER,
    ];

    public function __construct(NotificationService $notificationService)
    {
        $this->notificationService = $notificationService;
    }

    /**
     * Handle the UnpostedCollections "created" event.
     */
    public function created(UnpostedCollections $unpostedCollection): void
    {
        $amount = $unpostedCollection->amount ?? 0;
        $profileNumber = $unpostedCollection->profile?->profile_number ?? $unpostedCollection->profile_id ?? 'غير محدد';
        $currencyName = $unpostedCollection->currency?->currentTranslation?->name
            ?? $unpostedCollection->currency?->name
            ?? 'غير محدد';

        $title = 'تم الدفع';

        $message = "تم الدفع مبلغ {$amount} {$currencyName} على الملف رقم {$profileNumber}";

        if ($unpostedCollection->reference) {
            $message .= " - المرجع: {$unpostedCollection->reference}";
        }

        $data = [
            'unposted_collection_id' => $unpostedCollection->id,
            'profile_id' => $unpostedCollection->profile_id,
            'profile_number' => $profileNumber,
            'amount' => $amount,
            'currency_id' => $unpostedCollection->currency_id,
            'currency_name' => $currencyName,
            'date' => $unpostedCollection->date,
            'reference' => $unpostedCollection->reference,
            'customer_name' => $unpostedCollection->customer_name,
            'action' => 'created',
        ];

        foreach (self::TARGET_GROUPS as $group) {
            $this->notificationService->sendToGroup(
                groupId: $group->value,
                type: 'paid',
                title: $title,
                message: $message,
                modelName: 'UnpostedCollections',
                modelId: $unpostedCollection->id,
                data: $data,
                pushChannel: 'group'
            );
        }
    }
}
