<?php

namespace App\sys\Repository\Accounting;

use App\Models\Accounting\TreeAccountingTranslation;

class TreeAccountingTranslationRepository
{
    private TreeAccountingTranslation $translation;

    public function __construct()
    {
        $this->translation = new TreeAccountingTranslation;
    }

    public function save(array $data, int $treeId): bool
    {
        foreach ($data as $row) {
            if (isset($row['id']) && $row['id'] !== null) {
                $this->update($row);
            } else {
                $this->add($row, $treeId);
            }
        }

        return true;
    }

    public function add(array $data, int $treeId): void
    {
        $item = new TreeAccountingTranslation;
        $item->tree_accounting_id = $treeId;
        $item->lang_id = $data['language_id'];
        $item->title = $data['title'] ?? null;
        $item->description = $data['description'] ?? null;
        $item->save();
    }

    public function update(array $data): void
    {
        $item = $this->translation->find($data['id']);
        if ($item) {
            $item->title = $data['title'] ?? $item->title;
            $item->description = $data['description'] ?? $item->description;
            $item->save();
        }
    }

    public function get(int $treeId)
    {
        return $this->translation->with('getLang')->where('tree_accounting_id', $treeId)->get();
    }

    public function del(int $id): bool
    {
        $item = $this->translation->find($id);
        if ($item) {
            return (bool) $item->delete();
        }

        return false;
    }
}
