<?php

namespace App\sys\Repository\General;

use App\Models\Accounting\TreeAccounting;
use App\Models\General\Companies;
use App\Models\General\CompanyAccountMappings;
use App\Models\General\Currency;

class CompanyRepository
{
    public function getPaginated()
    {
        $column = request('sort_by', null);
        $order = request('sort_order', 'asc');
        $name = request('name', null);
        $limit = request('limit', 15);
        $query = Companies::query();
        $query->when($name, function ($q, $name) {
            $q->where('name_company', 'LIKE', "%$name%");
        });

        return $query->with('currentTranslation')->paginate($limit);
    }

    public function findByIdOrFail(int $id)
    {
        return Companies::with('accounting')->find($id);
    }

    public function getActive()
    {
        return Companies::with('currentTranslation')->where('is_active', 1)->get();
    }

    public function getByIdWithTranslation($id)
    {
        return Companies::with('translations')->find($id);
    }

    public function create(array $data)
    {
        $company = new Companies;
        $company->name_company = $data['name'];
        $company->companie_state = $data['companie_state'] ?? null;
        $company->companie_city = $data['companie_city'] ?? null;
        $company->companie_zip = $data['companie_zip'] ?? null;
        $company->company_vat = $data['company_vat'] ?? null;
        $company->companie_country = $data['companie_country'] ?? null;
        $company->companie_phone = $data['companie_phone'] ?? null;
        $company->companie_fax = $data['companie_fax'] ?? null;
        $company->companie_mobile = $data['companie_mobile'] ?? null;
        $company->companie_email = $data['companie_email'] ?? null;
        $company->invoice_logo = $data['logo'] ?? null;
        $company->image_stamp_docs = $data['docs'] ?? null;
        $company->image_stamp_docs_x = $data['image_stamp_docs_x'] ?? null;
        $company->image_stamp_docs_y = $data['image_stamp_docs_y'] ?? null;
        $company->image_stamp_docs_size = $data['image_stamp_docs_size'] ?? null;
        $company->apear_stamp = $data['apear_stamp'] ?? null;
        $company->default_invoice_footer = $data['default_invoice_footer'] ?? null;
        $company->companie_address_1 = $data['companie_address'];
        $company->issuer_type = $data['issuer_type'] ?? null;
        $company->issuer_id = $data['issuer_id'] ?? null;
        $company->issuer_name = $data['issuer_name'] ?? null;
        $company->issuer_branch_id = $data['issuer_branch_id'] ?? null;
        $company->issuer_country = $data['issuer_country'] ?? null;
        $company->issuer_governate = $data['issuer_governate'] ?? null;
        $company->issuer_region_city = $data['issuer_region_city'] ?? null;
        $company->issuer_region_street = $data['issuer_region_street'] ?? null;
        $company->issuer_building_number = $data['issuer_building_number'] ?? null;
        $company->issuer_postal_code = $data['issuer_postal_code'] ?? null;
        $company->issuer_floor = $data['issuer_floor'] ?? null;
        $company->issuer_room = $data['issuer_room'] ?? null;
        $company->issuer_landmark = $data['issuer_landmark'] ?? null;
        $company->issuer_additional_information = $data['issuer_additional_information'] ?? null;
        $company->customers_payments = $data['customers_payments'] ?? null;
        $company->is_active = $data['active'] ?? 1;
        $company->save();
        $this->saveAccounting($data, $company->id);

        return $company->load('accounting');
    }

    public function update($data)
    {
        $company = Companies::find($data['id']);
        $company->name_company = $data['name'];
        $company->companie_state = $data['companie_state'];
        $company->companie_city = $data['companie_city'];
        $company->companie_zip = $data['companie_zip'];
        $company->company_vat = $data['company_vat'];
        $company->companie_country = $data['companie_country'];
        $company->companie_phone = $data['companie_phone'];
        $company->companie_fax = $data['companie_fax'];
        $company->companie_mobile = $data['companie_mobile'];
        $company->companie_email = $data['companie_email'];
        $company->invoice_logo = $data['logo'] ?? $company->invoice_logo;
        $company->image_stamp_docs = $data['docs'] ?? $company->image_stamp_docs;
        $company->image_stamp_docs_x = $data['image_stamp_docs_x'];
        $company->image_stamp_docs_y = $data['image_stamp_docs_y'];
        $company->image_stamp_docs_size = $data['image_stamp_docs_size'];
        $company->apear_stamp = $data['apear_stamp'];
        $company->default_invoice_footer = $data['default_invoice_footer'];
        $company->companie_address_1 = $data['companie_address'];
        // $company->fund_account = $data['fund_account'];
        // $company->fund_account_cash = $data['fund_account_cash'];
        // $company->bank_tree_account = $data['bank_tree_account'];
        // $company->fund_hr = $data['fund_hr'];
        // $company->deposit = $data['deposit'];
        // $company->cach_custmer = $data['cach_custmer'];
        // $company->fund_hr_cash = $data['fund_hr_cash'];
        // $company->cost_center_id = $data['cost_center_id'];
        //  $company->cost_center_id_cr = $data['cost_center_id_cr'];
        $company->issuer_type = $data['issuer_type'];
        $company->issuer_id = $data['issuer_id'];
        $company->issuer_name = $data['issuer_name'];
        $company->issuer_branch_id = $data['issuer_branch_id'];
        $company->issuer_country = $data['issuer_country'];
        $company->issuer_governate = $data['issuer_governate'];
        $company->issuer_region_city = $data['issuer_region_city'];
        $company->issuer_region_street = $data['issuer_region_street'];
        $company->issuer_building_number = $data['issuer_building_number'];
        $company->issuer_postal_code = $data['issuer_postal_code'];
        $company->issuer_floor = $data['issuer_floor'];
        $company->issuer_room = $data['issuer_room'];
        $company->issuer_landmark = $data['issuer_landmark'];
        $company->issuer_additional_information = $data['issuer_additional_information'];
        $company->customers_payments = $data['customers_payments'];
        $company->is_active = $data['active'];
        $company->save();
        $this->updatedAccounting($data, $company->id);

        return $company->load('accounting');
    }

    private function updatedAccounting($data, $id)
    {
        foreach ($data['accounting'] ?? [] as $value) {
            if (CompanyAccountMappings::where(['company_id' => $id, 'type' => $value['input_name'], 'currency_id' => $value['currency_id']])->exists()) {
                $this->updatethisAccount($value, $id);
            } else {
                $this->addAccounting($value, $id);
            }
        }
    }

    public function updatethisAccount($data, $company_id)
    {
        $account = CompanyAccountMappings::where(['company_id' => $company_id, 'type' => $data['input_name'], 'currency_id' => $data['currency_id']])->first();
        $account->tree_account_id = $data['tree_account_id'];
        $account->save();
    }

    public function saveAccounting($data, $company_id)
    {
        foreach ($data['accounting'] as $value) {
            $this->addAccounting($value, $company_id);
        }
    }

    public function addAccounting($data, $company_id)
    {
        $account = new CompanyAccountMappings;
        $account->company_id = $company_id;
        $account->currency_id = $data['currency_id'];
        $account->tree_account_id = $data['tree_account_id'];
        $account->type = $data['input_name'];
        $account->save();
    }

    public function del(array $ids)
    {
        return CompanyAccountMappings::whereIn('id', $ids)->delete();
    }

    public function getAllChanges($company)
    {
        // Get company changes
        $companyChanges = $company->audits()
            ->with(['user' => function ($query) {
                $query->select('id', 'name');
            }])
            ->get()
            ->map(function ($audit) {
                $oldValues = $audit->old_values ?? [];
                $newValues = $audit->new_values ?? [];

                return [
                    'audit_id' => $audit->id,
                    'user_id' => $audit->user_id ?? null,
                    'user' => $audit->user ? $audit->user->toArray() : null,
                    'old_values' => $oldValues,
                    'new_values' => $newValues,
                    'changed_at' => $audit->created_at,
                    'event' => $audit->event,
                    'ip_address' => $audit->ip_address,
                    'user_agent' => $audit->user_agent,
                    'audit_type' => 'company',
                ];
            });

        // Get accounting mapping changes
        $accountingChanges = CompanyAccountMappings::where('company_id', $company->id)
            ->with(['audits' => function ($query) {
                $query->with(['user' => function ($userQuery) {
                    $userQuery->select('id', 'name');
                }]);
            }])
            ->get()
            ->flatMap(function ($accountingMapping) {
                return $accountingMapping->audits->map(function ($audit) {
                    $oldValues = $audit->old_values ?? [];
                    $newValues = $audit->new_values ?? [];

                    // Resolve currency and tree account names
                    $currencyIds = array_filter([
                        $oldValues['currency_id'] ?? null,
                        $newValues['currency_id'] ?? null,
                    ]);
                    $treeAccountIds = array_filter([
                        $oldValues['tree_account_id'] ?? null,
                        $newValues['tree_account_id'] ?? null,
                    ]);

                    $currencies = $currencyIds ? Currency::whereIn('id', $currencyIds)
                        ->pluck('name', 'id')
                        ->toArray() : [];
                    $treeAccounts = $treeAccountIds ? TreeAccounting::whereIn('tree_accounting_id', $treeAccountIds)
                        ->pluck('title', 'tree_accounting_id')
                        ->toArray() : [];

                    if (isset($oldValues['currency_id']) && isset($currencies[$oldValues['currency_id']])) {
                        $oldValues['currency_name'] = $currencies[$oldValues['currency_id']];
                    }
                    if (isset($newValues['currency_id']) && isset($currencies[$newValues['currency_id']])) {
                        $newValues['currency_name'] = $currencies[$newValues['currency_id']];
                    }

                    if (isset($oldValues['tree_account_id']) && isset($treeAccounts[$oldValues['tree_account_id']])) {
                        $oldValues['tree_account_name'] = $treeAccounts[$oldValues['tree_account_id']];
                    }
                    if (isset($newValues['tree_account_id']) && isset($treeAccounts[$newValues['tree_account_id']])) {
                        $newValues['tree_account_name'] = $treeAccounts[$newValues['tree_account_id']];
                    }

                    return [
                        'audit_id' => $audit->id,
                        'user_id' => $audit->user_id ?? null,
                        'user' => $audit->user ? $audit->user->toArray() : null,
                        'old_values' => $oldValues,
                        'new_values' => $newValues,
                        'changed_at' => $audit->created_at,
                        'event' => $audit->event,
                        'ip_address' => $audit->ip_address,
                        'user_agent' => $audit->user_agent,
                        'audit_type' => 'accounting_mapping',
                        'accounting_mapping_id' => $audit->auditable_id,
                    ];
                });
            });

        // Combine and sort all changes by timestamp
        $allChanges = $companyChanges->concat($accountingChanges)
            ->sortByDesc('changed_at')
            ->values();

        return $allChanges;
    }
}
