<?php

namespace App\sys\Repository\General;

use App\Models\General\GuideLanguage;

class GuideLanguageRepository
{
    private $columns = [
        'id' => 'id',
        'name' => 'name',
        'active' => 'is_active',
        'created_at' => 'created_at',
        'updated_at' => 'updated_at',
    ];

    public function getPaginated()
    {
        $column = request('sort_by', null);
        $order = request('sort_order', 'asc');
        $name = request('name', null);
        $limit = request('limit', 15);

        return GuideLanguage::when($name, function ($q, $name) {
            $q->whereHas('currentTranslation', function ($q) use ($name) {
                $q->where('name', 'LIKE', "%$name%");
            });
        })->when($column && array_key_exists($column, $this->columns), function ($query) use ($column, $order) {
            if ($column == 'name') {
                $query->leftJoin('guide_language_translation', function ($join) {
                    $join->on('guide_language.id', '=', 'guide_language_translation.guide_language_id')
                        ->where('guide_language_translation.lang_id', app('lang_id'));
                })->orderBy('guide_language_translation.name', $order)->select('guide_language.*');
            } else {
                $query->orderBy($this->columns[$column], $order);
            }
        })->with('currentTranslation')->paginate($limit);
    }

    public function findByIdOrFail(int $id)
    {
        return GuideLanguage::with('currentTranslation')->find($id);
    }

    public function create(array $data)
    {
        $model = new GuideLanguage;
        $model->name = $data['name'];
        $model->is_active = $data['active'];
        $model->save();

        return $model;
    }

    public function update(GuideLanguage $model, array $data)
    {
        $model->name = $data['name'] ?? $model->name;
        $model->is_active = $data['active'] ?? $model->is_active;
        $model->save();

        return $model;
    }

    public function delete(GuideLanguage $model)
    {
        return $model->delete();
    }

    public function del(array $ids)
    {
        return GuideLanguage::whereIn('id', $ids)->delete();
    }

    public function getActive()
    {
        return GuideLanguage::with('currentTranslation')->where('is_active', 1)->get();
    }

    public function getByIdWithTranslation($id)
    {
        return GuideLanguage::with('translations')->find($id);
    }
}
