<?php

namespace App\sys\Services\General;

use App\sys\Repository\General\TransportationModesRepository;
use App\sys\Services;
use Illuminate\Support\Facades\Validator;

class TransportationModesService extends Services
{
    private $repo;

    public function __construct()
    {
        $this->repo = new TransportationModesRepository;
    }

    public function create(array $data)
    {
        $validator = Validator::make($data, [
            'name' => 'required|string|max:300',
        ]);
        if ($validator->fails()) {
            $this->setError($validator->errors());

            return false;
        }
        $transportationMode = $this->repo->create($data);
        $this->syncTranslations($transportationMode);

        return $transportationMode;
    }

    public function update(array $data)
    {
        $validator = Validator::make($data, [
            'id' => ['required', 'integer', 'exists:ge_transportation_modes,id'],
            'name' => ['sometimes', 'string', 'max:255'],
            'active' => ['sometimes', 'in:0,1'],
        ]);
        if ($validator->fails()) {
            $this->setError($validator->errors());

            return false;
        }

        return $this->repo->update($data);
    }

    public function index()
    {
        return $this->repo->index();
    }

    public function getById($id)
    {
        return $this->repo->getById($id);
    }

    public function getActive()
    {
        return $this->repo->getActive();
    }

    public function del(array $ids)
    {
        if (empty($ids)) {
            $this->setError(['ids' => 'No IDs provided']);

            return false;
        }

        return $this->repo->del($ids);
    }

    public function getWithTranslation($id)
    {
        $transportationMode = $this->repo->getByIdWithTranslation($id);

        return $this->syncTranslations($transportationMode, true);
    }

    public function getAllChanges($transportationMode)
    {
        return $this->repo->getAllChanges($transportationMode);
    }
}
