<?php

namespace App\Http\Controllers\Accommodation;

use App\Http\Controllers\Controller;
use App\Http\Resources\Accommodation\RoomTypeHistoryResource;
use App\Http\Resources\RoomTypesCollection;
use App\Http\Resources\RoomTypesResource;
use App\sys\ApiResponse;
use Illuminate\Http\Request;

class RoomTypesController extends Controller
{
    use ApiResponse;

    private $roomTypes;

    private $roomTypeTranslationServices;

    public function __construct()
    {
        $this->roomTypes = new \App\sys\Services\Accommodation\RoomTypesServices;
        $this->roomTypeTranslationServices = new \App\sys\Services\Accommodation\RoomTypeTranslationServices;
    }

    public function create(Request $request)
    {
        if ($meal = $this->roomTypes->add($request->all())) {
            $collect = new RoomTypesResource($meal);

            return $this->apiResponse(200, 'Meal Plan created successfully', null, $collect);
        }

        $errors = $this->roomTypes->errors();

        return $this->apiResponse(400, 'Error creating meal plan', $errors, null);
    }

    public function update(Request $request)
    {
        if ($meal = $this->roomTypes->update($request->all())) {
            $collect = new RoomTypesResource($meal);

            return $this->apiResponse(200, 'Meal Plan created successfully', null, $collect);
        }

        $errors = $this->roomTypes->errors();

        return $this->apiResponse(400, 'Error creating meal plan', $errors, null);
    }

    public function index()
    {
        $data = $this->roomTypes->get();
        $collect = new RoomTypesCollection($data);

        return $this->apiResponse(200, 'Meal Plan created successfully', null, $collect);
    }

    public function getByid($id = 0)
    {
        if ($data = $this->roomTypes->getById($id)) {
            $collect = new RoomTypesResource($data);

            return $this->apiResponse(200, 'Meal Plan retrieved successfully', null, $collect);
        }

        return $this->apiResponse(400, 'Meal Plan not found', ['room type not found'], null);
    }

    public function getActive()
    {
        $data = $this->roomTypes->getActive();
        $collect = new \App\Http\Resources\RoomTypesCollection($data);

        return $this->apiResponse(200, 'Active Room Types retrieved successfully', null, $collect);
    }

    public function destroy(Request $request)
    {
        $ids = $request->input('ids', []);
        if (! is_array($ids) || empty($ids)) {
            return $this->apiResponse(400, 'No IDs provided for deletion', null, null);
        }
        $result = $this->roomTypes->del($ids);
        if ($result) {
            return $this->apiResponse(200, 'Room Types deleted successfully', null, null);
        }
        $errors = $this->roomTypes->errors();

        return $this->apiResponse(400, 'fail', $errors, null);
    }

    public function saveTranslation(Request $request, $id)
    {
        if (! $this->roomTypeTranslationServices->save($request->all(), $id)) {
            $errors = $this->roomTypeTranslationServices->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        return $this->apiResponse(200, 'success', null, null);
    }

    public function getTranslation($id)
    {
        if ($data = $this->roomTypes->getByIdWithTranslation($id)) {
            $collection = new \App\Http\Resources\Accommodation\RoomType\RoomTypeLangResource($data);

            return $this->apiResponse(200, 'success', null, $collection);
        }
        $errors = $this->roomTypes->errors();

        return $this->apiResponse(400, 'fail', $errors, null);
    }

    public function delLang($id)
    {
        if ($this->roomTypeTranslationServices->del($id)) {
            return $this->apiResponse(200, 'success', null, null);
        }

        $errors = $this->roomTypeTranslationServices->errors();

        return $this->apiResponse(400, 'fail', $errors, null);
    }

    public function getAllChanges($id)
    {
        $roomType = $this->roomTypes->getById($id);
        if (! $roomType) {
            $errors = $this->roomTypes->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        $changes = $this->roomTypes->getAllChanges($roomType);

        return $this->apiResponse(200, 'success', null, RoomTypeHistoryResource::collection($changes));
    }
}
