<?php

namespace App\Http\Controllers\Accommodation;

use App\Http\Controllers\Controller;
use App\Http\Resources\Accommodation\RoomViewHistoryResource;
use App\Http\Resources\RoomViewsCollection;
use App\Http\Resources\RoomViewsResource;
use App\sys\ApiResponse;
use App\sys\Services\Accommodation\RoomViewsServices;
use Illuminate\Http\Request;

class RoomViewController extends Controller
{
    use ApiResponse;

    private $room;

    private $roomTranslationServices;

    public function __construct()
    {
        $this->room = new RoomViewsServices;
        $this->roomTranslationServices = new \App\sys\Services\Accommodation\RoomViewTranslationServices;
    }

    public function create(Request $request)
    {
        if ($meal = $this->room->add($request->all())) {
            $collect = new RoomViewsResource($meal);

            return $this->apiResponse(200, 'Meal Plan created successfully', null, $collect);
        }

        $errors = $this->room->errors();

        return $this->apiResponse(400, 'Error creating meal plan', $errors, null);
    }

    public function update(Request $request)
    {
        if ($meal = $this->room->update($request->all())) {
            $collect = new RoomViewsResource($meal);

            return $this->apiResponse(200, 'Meal Plan created successfully', null, $collect);
        }

        $errors = $this->room->errors();

        return $this->apiResponse(400, 'Error creating meal plan', $errors, null);
    }

    public function index()
    {
        $data = $this->room->get();
        $collect = new RoomViewsCollection($data);

        return $this->apiResponse(200, 'Meal Plan created successfully', null, $collect);
    }

    public function getByid($id = 0)
    {
        if ($data = $this->room->getById($id)) {
            $collect = new RoomViewsResource($data);

            return $this->apiResponse(200, 'Meal Plan retrieved successfully', null, $collect);
        }

        return $this->apiResponse(400, 'Meal Plan not found', ['room view not found'], null);
    }

    public function getActive()
    {
        $data = $this->room->getActive();
        $collect = new \App\Http\Resources\RoomViewsCollection($data);

        return $this->apiResponse(200, 'Active Room Views retrieved successfully', null, $collect);
    }

    public function destroy(Request $request)
    {
        $ids = $request->input('ids', []);
        if (! is_array($ids) || empty($ids)) {
            return $this->apiResponse(400, 'No IDs provided for deletion', null, null);
        }
        $result = $this->room->del($ids);
        if ($result) {
            return $this->apiResponse(200, 'Room Views deleted successfully', null, null);
        }
        $errors = $this->room->errors();

        return $this->apiResponse(400, 'fail', $errors, null);
    }

    public function saveTranslation(Request $request, $id)
    {
        if (! $this->roomTranslationServices->save($request->all(), $id)) {
            $errors = $this->roomTranslationServices->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        return $this->apiResponse(200, 'success', null, null);
    }

    public function getTranslation($id)
    {
        if ($data = $this->room->getByIdWithTranslation($id)) {
            $collection = new \App\Http\Resources\Accommodation\RoomView\RoomViewLangResource($data);

            return $this->apiResponse(200, 'success', null, $collection);
        }
        $errors = $this->room->errors();

        return $this->apiResponse(400, 'fail', $errors, null);
    }

    public function delLang($id)
    {
        if ($this->roomTranslationServices->del($id)) {
            return $this->apiResponse(200, 'success', null, null);
        }

        $errors = $this->roomTranslationServices->errors();

        return $this->apiResponse(400, 'fail', $errors, null);
    }

    public function getAllChanges($id)
    {
        $roomView = $this->room->getById($id);
        if (! $roomView) {
            $errors = $this->room->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        $changes = $this->room->getAllChanges($roomView);

        return $this->apiResponse(200, 'success', null, RoomViewHistoryResource::collection($changes));
    }
}
