<?php

namespace App\Http\Controllers\Config;

use App\Http\Controllers\Controller;
use App\sys\ApiResponse;

class ConfigController extends Controller
{
    use ApiResponse;

    /**
     * Get Reverb configuration for frontend (Angular)
     */
    public function reverbConfig()
    {
        $appUrl = config('app.url');
        $parsed = parse_url($appUrl);

        $reverbHost = env('REVERB_HOST', $parsed['host'] ?? 'localhost');
        $reverbPort = env('REVERB_PORT', 8080);
        $reverbScheme = env('REVERB_SCHEME', $parsed['scheme'] ?? 'http');

        return $this->apiResponse(200, 'success', null, [
            'reverb' => [
                'app_key' => config('broadcasting.connections.reverb.key'),
                'app_id' => config('broadcasting.connections.reverb.app_id'),
                'host' => $reverbHost,
                'port' => (int) $reverbPort,
                'scheme' => $reverbScheme,
                'useTLS' => $reverbScheme === 'https',
                'auth_endpoint' => route('broadcasting.auth'),
            ],
        ]);
    }
}
