<?php

namespace App\Http\Controllers\General;

use App\Http\Controllers\Controller;
use App\Http\Resources\General\NationalityHistoryResource;
use App\Http\Resources\NationalityCollection;
use App\Http\Resources\NationalityResource;
use App\sys\ApiResponse;
use App\sys\Services\General\NationalityService;
use Illuminate\Http\Request;

class NationalityController extends Controller
{
    use ApiResponse;

    protected NationalityService $nationalityService;

    private $nationalityTranslationService;

    public function __construct(NationalityService $nationalityService)
    {
        $this->nationalityService = $nationalityService;
        $this->nationalityTranslationService = new \App\sys\Services\General\NationalityTranslationService;
    }

    /**
     * Display a listing of the resource.
     */
    public function index()
    {

        $nationalities = $this->nationalityService->getPaginatedNationalities();

        return $this->apiResponse(200, 'success', null, new NationalityCollection($nationalities));
    }

    /**
     * Display the specified resource.
     */
    public function show(int $id)
    {
        $nationality = $this->nationalityService->getNationalityById($id);

        if (! $nationality) {
            $errors = $this->nationalityService->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        return $this->apiResponse(200, 'success', null, new NationalityResource($nationality));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $response = $this->nationalityService->createNationality($request->all());

        if (! $response) {
            $errors = $this->nationalityService->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        return $this->apiResponse(200, 'success', null, new NationalityResource($response));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request)
    {
        $response = $this->nationalityService->updateNationality($request->all());

        if (! $response) {
            $errors = $this->nationalityService->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        return $this->apiResponse(200, 'success', null, new NationalityResource($response));
    }

    public function getActive()
    {
        $data = $this->nationalityService->getActive();
        $collect = new \App\Http\Resources\NationalityCollection($data);

        return $this->apiResponse(200, 'Active Nationalities retrieved successfully', null, $collect);
    }

    public function destroy(Request $request)
    {
        $ids = $request->input('ids', []);
        if (! is_array($ids) || empty($ids)) {
            return $this->apiResponse(400, 'No IDs provided for deletion', null, null);
        }
        $result = $this->nationalityService->del($ids);
        if ($result) {
            return $this->apiResponse(200, 'Nationalities deleted successfully', null, null);
        }
        $errors = $this->nationalityService->errors();

        return $this->apiResponse(400, 'fail', $errors, null);
    }

    public function saveTranslation(Request $request, $id)
    {
        if (! $this->nationalityTranslationService->save($request->all(), $id)) {
            $errors = $this->nationalityTranslationService->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        return $this->apiResponse(200, 'success', null, null);
    }

    public function getTranslation($id)
    {
        if ($data = $this->nationalityService->getByIdWithTranslation($id)) {
            $collection = new \App\Http\Resources\General\Nationality\NationalityLangResource($data);

            return $this->apiResponse(200, 'success', null, $collection);
        }
        $errors = $this->nationalityService->errors();

        return $this->apiResponse(400, 'fail', $errors, null);
    }

    public function delLang($id)
    {
        if ($this->nationalityTranslationService->del($id)) {
            return $this->apiResponse(200, 'success', null, null);
        }

        $errors = $this->nationalityTranslationService->errors();

        return $this->apiResponse(400, 'fail', $errors, null);
    }

    public function getAllChanges($id)
    {
        $nationality = $this->nationalityService->getNationalityById($id);
        if (! $nationality) {
            $errors = $this->nationalityService->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        $changes = $this->nationalityService->getAllChanges($nationality);

        return $this->apiResponse(200, 'success', null, NationalityHistoryResource::collection($changes));
    }
}
