<?php

namespace App\Http\Controllers\Lagnuages;

use App\Http\Controllers\Controller;
use App\Http\Resources\LanguageActiveCollection;
use App\Http\Resources\LanguageCollection;
use App\Http\Resources\LanguageResource;
use App\sys\ApiResponse;
use App\sys\Services\Languages\LagnuagesServices;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;

class LagnuagesControllers extends Controller
{
    use ApiResponse;

    private $lang;

    public function __construct(LagnuagesServices $lang)
    {
        $this->lang = $lang;
    }

    public function index()
    {
        $lang = $this->lang->get();
        $collect = new LanguageCollection($lang);

        return $this->apiResponse(200, 'Languages retrieved successfully', null, $collect);
    }

    public function getByid($id)
    {
        if ($lang = $this->lang->getByid($id)) {
            $collect = new LanguageResource($lang);

            return $this->apiResponse(200, 'Language retrieved successfully', null, $collect);
        }

        return $this->apiResponse(400, 'Language not found', ['Not Found Data'], null);
    }

    public function getActive()
    {
        $lang = $this->lang->getActive();
        $collect = new LanguageActiveCollection($lang);

        return $this->apiResponse(200, 'Languages retrieved successfully', null, $collect);
    }

    public function add(Request $request)
    {
        if ($lang = $this->lang->add($request->all())) {
            $collect = new LanguageResource($lang);

            return $this->apiResponse(200, 'Language created successfully', null, $collect);
        }

        return $this->apiResponse(400, 'Error creating language', $this->lang->errors(), null);
    }

    public function updated(Request $request)
    {
        if ($lang = $this->lang->updated($request->all())) {
            $collect = new LanguageResource($lang);

            return $this->apiResponse(200, 'Language updated successfully', null, $collect);
        }

        return $this->apiResponse(400, 'Error updating language', $this->lang->errors(), null);
    }

    public function getCountryCode()
    {
        $countryCode = [];
        foreach (File::files(base_path('public/images/flags')) as $path) {
            $countryCode[] = [
                'code' => pathinfo($path)['filename'],
                'name' => strtoupper(pathinfo($path)['filename']),
                'path' => asset('/images/flags/'.pathinfo($path)['filename'].'.png'),
            ];
        }

        return $this->apiResponse(200, 'Country codes retrieved successfully', null, $countryCode);
    }
}
