<?php

namespace App\Http\Resources\Accounting;

use Illuminate\Http\Resources\Json\JsonResource;

class TreeAccountSettingResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'tree_account_id' => $this->tree_account_id ?? null,
            'type' => $this->type ?? null,
            'tree_name' => $this->whenLoaded('tree', fn () => $this->tree->title ?? null),
            'created_at' => $this->created_at ?? null,
            'updated_at' => $this->updated_at ?? null,
        ];
    }
}
