<?php

namespace App\Http\Resources\Accounting;

use Illuminate\Http\Resources\Json\JsonResource;

class TreeAccountingLangResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'title' => $this->title,
            'description' => $this->description,
            'serial_number' => $this->serial_number,
            'serial_number_dight' => $this->serial_number_dight,
            'active' => $this->active,
            'created_at' => $this->created,
            'updated_at' => $this->modified,
            'translations' => ($this->translations && $this->translations->isNotEmpty())
                ? TreeAccountingTranslationResource::collection($this->translations)
                : null,
        ];
    }
}
