<?php

namespace App\Http\Resources\Accounting;

use Illuminate\Http\Resources\Json\JsonResource;

class TreeAccountingTranslationResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'tree_accounting_id' => $this->tree_accounting_id,
            'lang_id' => $this->lang_id,
            'title' => $this->title,
            'description' => $this->description,
            'lang_name' => $this->getLang->name ?? null,
            'lang_code' => $this->getLang->code ?? null,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
