<?php

namespace App\Http\Resources\General\City;

use Illuminate\Http\Resources\Json\JsonResource;

class CityLangResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'country_id' => $this->country_id,
            'active' => $this->is_active,
            'short_cut' => $this->short_cut,
            'created_at' => $this->created,
            'updated_at' => $this->modified,
            'translations' => ($this->translations && $this->translations->isNotEmpty())
                ? CityTranslationResource::collection($this->translations)
                : null,
        ];
    }
}
