<?php

namespace App\Http\Resources\General\Currency;

use Illuminate\Http\Resources\Json\JsonResource;

class CurrencyLangResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'code' => $this->code,
            'symbol' => $this->symbol,
            'active' => $this->is_active,
            'created_at' => $this->created,
            'updated_at' => $this->modified,
            'translations' => ($this->translations && $this->translations->isNotEmpty())
                ? CurrencyTranslationResource::collection($this->translations)
                : null,
        ];
    }
}
