<?php

namespace App\Http\Resources\General\GuideLanguage;

use Illuminate\Http\Resources\Json\JsonResource;

class GuideLanguageLangResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'code' => $this->code,
            'active' => $this->is_active,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'translations' => ($this->translations && $this->translations->isNotEmpty())
                ? GuideLanguageTranslationResource::collection($this->translations)
                : null,
        ];
    }
}
