<?php

namespace App\Http\Resources\General\Restaurant;

use Illuminate\Http\Resources\Json\JsonResource;

class RestaurantLangResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'active' => $this->is_active,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'translations' => ($this->translations && $this->translations->isNotEmpty())
                ? RestaurantTranslationResource::collection($this->translations)
                : null,
        ];
    }
}
