<?php

namespace App\Http\Resources\Invoice;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class SegmentsResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'invoice_services_id' => $this->invoice_services_id,
            'origin_airport' => $this->origin_airport,
            'destination_airport' => $this->destination_airport,
            'date' => $this->date?->format('Y-m-d'),
            'time' => $this->time,
            'type' => $this->type,
            'flight_number' => $this->flight_number,
            'flight_company' => $this->flight_company,
            'origin_airport_data' => $this->whenLoaded('originAirport'),
            'destination_airport_data' => $this->whenLoaded('destinationAirport'),
            'flight_company_data' => $this->whenLoaded('flightCompany'),
        ];
    }
}
