<?php

namespace App\Http\Resources\Profile;

use Illuminate\Http\Resources\Json\JsonResource;

class ProfileTravelersResource extends JsonResource
{
    protected $travelers;

    protected $profile_id;

    public function __construct($profile_id, $travelers)
    {
        parent::__construct(null);
        $this->profile_id = $profile_id;
        $this->travelers = $travelers;
    }

    public function toArray($request)
    {
        $adults = $this->travelers->where('type', 'adult')->values();
        $children = $this->travelers->where('type', 'child')->values();

        return [
            'profile_id' => $this->profile_id,
            'travelers' => [
                'adults' => $adults->isEmpty() ? null : TravelerResource::collection($adults),
                'children' => $children->isEmpty() ? null : TravelerResource::collection($children),
            ],
        ];
    }
}
