<?php

namespace App\Models\Accommodation;

use App\Models\General\City;
use App\Models\General\Country;
use App\Models\Suppliers\Suppliers;
use App\Models\User;
use Illuminate\Database\Eloquent\Model;

class Accommodations extends Model
{
    protected $table = 'ac_accommodations';

    protected $fillable = [
        'name',
        'description',
        'type',
        'rating_id',
        'country_id',
        'city_id',
        'is_active',
        'address',
        'phone',
        'email',
        'website',
        'taxable',
        'is_main_provider',
        'google_map_link',
    ];

    const CREATED_AT = 'created';

    const UPDATED_AT = 'modified';

    public function country()
    {
        return $this->belongsTo(Country::class, 'country_id');
    }

    public function city()
    {
        return $this->belongsTo(City::class, 'city_id');
    }

    public function rating()
    {
        return $this->belongsTo(Rating::class, 'rating_id');
    }

    public function suppliers()
    {
        return $this->belongsToMany(Suppliers::class, 'supplier_accommodation', 'accommodation_id', 'supplier_id');
    }

    public function translations()
    {
        return $this->hasMany(AccommodationsTranslations::class, 'accommodation_id');
    }

    public function currentTranslation()
    {
        return $this->hasOne(AccommodationsTranslations::class, 'accommodation_id')
            ->where('lang_id', app('lang_id'));
    }

    public function users()
    {
        return $this->belongsToMany(User::class, 'ac_accommodation_user', 'ac_accommodation_id', 'user_id')->withPivot('type');
    }

    public function accommodationsCurrencies()
    {
        return $this->hasMany(AccommodationsCurrencies::class, 'accommodation_id');
    }
}
